/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.tool.redis;

import cn.com.yusys.yusp.commons.fee.common.operation.RedisOperations;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class BaseRedisOperations
implements RedisOperations {
    private static final Logger logger = LoggerFactory.getLogger(BaseRedisOperations.class);
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long time) {
        if (time > 0L) {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
        } else {
            this.set(key, value);
        }
    }

    public void setNx(String key, Object value) {
        this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
    }

    public Boolean expire(String key, long time) {
        if (time > 0L) {
            return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
        }
        throw new IllegalArgumentException("expire must be greater than 0.");
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Long del(String ... key) {
        if (key != null && key.length > 0) {
            return this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
        }
        return 0L;
    }
}

