/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.swagger;

import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.enums.SwaggerParamType;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ParamDefinition;
import cn.com.yusys.yusp.commons.fee.swagger.SwaggerModelProcessor;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import springfox.documentation.OperationNameGenerator;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingScannerPlugin;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spring.web.readers.operation.CachingOperationNameGenerator;

@Order(value=-2147482648)
public class FeeApiListingScannerPlugin
implements ApiListingScannerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(FeeApiListingScannerPlugin.class);
    private static final String POST_PARAM_MODEL_DES = "\u8f93\u5165\u6a21\u578b";
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;
    @Autowired
    private SwaggerModelProcessor swaggerModelProcessor;
    @Autowired
    private CachingOperationNameGenerator operationNames;
    @Autowired
    private TypeResolver typeResolver;

    public List<ApiDescription> apply(DocumentationContext context) {
        this.swaggerModelProcessor.addModel(context);
        ArrayList<ApiDescription> apiList = new ArrayList<ApiDescription>();
        Map flows = this.flowDefinitionRegistry.getAllFlow();
        for (Map.Entry entry : flows.entrySet()) {
            Class clazz;
            FlowDefinition v = (FlowDefinition)entry.getValue();
            if (!v.isPublish() || (clazz = this.swaggerModelProcessor.getResultModel().get(v.getFlowId())) == null) continue;
            ModelRef modelRef = new ModelRef(clazz.getSimpleName());
            String summary = v.getSwaggerSummary();
            if (StringUtils.isEmpty((Object)summary)) {
                summary = v.getUrl();
            }
            List<Operation> operations = Collections.singletonList(new OperationBuilder((OperationNameGenerator)this.operationNames).tags(this.genTags(v.getSwaggerTags())).summary(summary).consumes(Collections.singleton(v.getSwaggerConsumes())).produces(Collections.singleton(v.getSwaggerProduces())).authorizations(new ArrayList()).method(HttpMethod.resolve((String)v.getRequestType().toUpperCase())).notes(v.getDescription()).parameters(this.genParameters(v)).responseMessages(this.responseMessages(modelRef)).responseModel((ModelReference)modelRef).build());
            ApiDescription apiDescription = new ApiDescription("", v.getUrl(), v.getDescription(), operations, Boolean.valueOf(false));
            apiList.add(apiDescription);
        }
        return apiList;
    }

    private Set<String> genTags(String tags) {
        HashSet<String> set = new HashSet<String>();
        if (!StringUtils.isEmpty((Object)tags)) {
            String[] array = tags.split(",");
            set.addAll(Arrays.asList(array));
        }
        return set;
    }

    private List<Parameter> genParameters(FlowDefinition flowDefinition) {
        String requestType = flowDefinition.getRequestType();
        if ("GET".equalsIgnoreCase(requestType)) {
            return this.genGetParameters(flowDefinition);
        }
        if ("POST".equalsIgnoreCase(requestType)) {
            return this.genPostParameters(flowDefinition);
        }
        return new ArrayList<Parameter>();
    }

    private List<Parameter> genGetParameters(FlowDefinition flowDefinition) {
        List input = flowDefinition.getInput();
        if (input != null && !input.isEmpty()) {
            ParamDefinition p = (ParamDefinition)input.get(0);
            if (input.size() == 1 && !ClassUtil.isBasicType((StringBuilder)new StringBuilder(p.getClassName()))) {
                try {
                    Class<?> clazz = Class.forName(p.getClassName());
                    Field[] fields = clazz.getDeclaredFields();
                    ArrayList<Definition> newInput = new ArrayList<Definition>();
                    for (Field field : fields) {
                        ParamDefinition pd = new ParamDefinition();
                        pd.setClassName(field.getType().getName());
                        pd.setName(field.getName());
                        newInput.add((Definition)pd);
                    }
                    return this.genGetParameters(newInput);
                }
                catch (ClassNotFoundException e) {
                    logger.debug("", (Throwable)e);
                }
            } else {
                return this.genGetParameters(input);
            }
        }
        return new ArrayList<Parameter>();
    }

    private List<Parameter> genGetParameters(List<Definition> input) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String swaggerParameterType = SwaggerParamType.QUERY.getValue();
        for (Definition d : input) {
            ParamDefinition p = (ParamDefinition)d;
            Parameter parameter = this.genParameter(p, swaggerParameterType);
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private List<Parameter> genPostParameters(FlowDefinition flowDefinition) {
        List input = flowDefinition.getInput();
        String swaggerParameterType = SwaggerParamType.BODY.getValue();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (input != null && !input.isEmpty()) {
            Parameter parameter = null;
            ParamDefinition firstParamDefinition = (ParamDefinition)input.get(0);
            if (input.size() == 1 && !ClassUtil.isBasicType((StringBuilder)new StringBuilder(firstParamDefinition.getClassName()))) {
                parameter = this.genParameter(firstParamDefinition, swaggerParameterType);
            } else {
                try {
                    Class clazz = this.swaggerModelProcessor.getParamPostModel().get(flowDefinition.getFlowId());
                    if (clazz != null) {
                        String simpleName = clazz.getSimpleName();
                        parameter = new ParameterBuilder().description(POST_PARAM_MODEL_DES).type(this.typeResolver.resolve((Type)clazz, new Type[0])).name(simpleName).parameterType(swaggerParameterType).required(true).modelRef((ModelReference)new ModelRef(simpleName)).build();
                    }
                }
                catch (Exception e) {
                    logger.debug("", (Throwable)e);
                }
            }
            if (parameter != null) {
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    private Parameter genParameter(ParamDefinition p, String swaggerParameterType) {
        String className = p.getClassName();
        if (StringUtils.isEmpty((Object)className)) {
            return null;
        }
        className = ClassUtil.convertBasicType((String)className, (boolean)p.isArray());
        SwaggerParamType type = SwaggerParamType.getTypeByValue((String)p.getSwaggerParameterType());
        if (type != null) {
            swaggerParameterType = type.getValue();
        }
        try {
            return new ParameterBuilder().description(p.getDescription()).type(this.typeResolver.resolve(Class.forName(className), new Type[0])).name(p.getName()).parameterType(swaggerParameterType).required(p.isSwaggerRequired()).modelRef((ModelReference)new ModelRef(this.getModelName(className))).build();
        }
        catch (Exception e) {
            logger.debug("", (Throwable)e);
            return null;
        }
    }

    private String getModelName(String className) {
        String modelName = "";
        if (!StringUtils.isEmpty((Object)className) && className.contains(".")) {
            modelName = className.substring(className.lastIndexOf(46) + 1);
        }
        return modelName;
    }

    private Set<ResponseMessage> responseMessages(ModelRef modelRef) {
        return Collections.singleton(new ResponseMessageBuilder().code(200).message("Success").responseModel((ModelReference)modelRef).build());
    }

    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_2.equals((Object)delimiter);
    }
}

