/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.collection;

import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CataLog(nodeType=ActionNodeType.BIZ, value="tyzj/jh/sz")
public class ArrayLogic {
    private static final Logger logger = LoggerFactory.getLogger(ArrayLogic.class);

    @Logic(description="newArray")
    public Object[] newArray(@LogicParam(description="szdx") int n) {
        if (n < 1) {
            logger.error("Array size cannot be less than 1, the array size is {}", (Object)n);
            throw new IllegalArgumentException("Array size cannot be less than 1");
        }
        return new Object[n];
    }

    @Logic(description="addAt")
    public void addAt(@LogicParam(description="sxwsz") Object[] array, @LogicParam(description="szsy") int index, @LogicParam(description="z") Object value) {
        this.check(array, index);
        array[index] = value;
    }

    @Logic(description="getByIndex")
    public Object getByIndex(@LogicParam(description="sxwsz") Object[] array, @LogicParam(description="szsy") int index) {
        this.check(array, index);
        return array[index];
    }

    @Logic(description="length")
    public int length(@LogicParam(description="sxwsz") Object[] array) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException("Empty array");
        }
        return array.length;
    }

    private void check(Object[] array, int index) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException("Empty array");
        }
        if (index < 0 || index > array.length) {
            logger.error("Array boundary overflow, index={}, array.length={}", (Object)index, (Object)array.length);
            throw new IllegalArgumentException("Array boundary overflow");
        }
    }
}

