/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.exception;

import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;

public enum Error {
    INNER_ERROR("000001", "Internal Error"),
    NOT_FOUND("000002", "No interface found"),
    XML_PARSE_ERROR("000003", "xml parsing exception"),
    API_REGISTRY_ERROR("000004", "API registration exception"),
    NO_REQUIRED_BEAN("000005", "Missing required bean"),
    ING("100000", "Running, please wait"),
    ACTION_ASYNC_FAILED("100001", "Component executed asynchronously and aborted"),
    ACTION_NEXT_NULL("100002", "The next node of component not found"),
    ACTION_CONCURRENT_CLOSE_FAILED("100003", "Concurrent component shutdown exception"),
    ACTION_CONCURRENT_CLOSE_TIMEOUT("100013", "Concurrent component timeout"),
    ACTION_NO_PARAMS("100004", "Component has no parameters"),
    ACTION_LACK_ATTRIBUTE("100005", "Component is missing required properties"),
    ACTION_ATTRIBUTE_EXCEPTION("100006", "Component property exception"),
    ACTION_TYPE_EXCEPTION("100007", "Component type exception"),
    ASSIGN_TYPE_INVALID("100008", "Data value and type mismatch, unable to conversion"),
    IDEMPOTENT_ERROR("100009", "Idempotent Exception"),
    NO_START_ACTION("100010", "Missing start node"),
    MULTIPLE_START_ACTION("100011", "Multiple start nodes"),
    ACTION_NO_LEFT_PARAM("100012", "The variable name cannot be empty"),
    COMMUNICATE_MS_FAILED("110001", "Microservice request failed"),
    COMMUNICATE_BSP_FAILED("110002", "Bsp communication failed"),
    CONTEXT_NO_PARAMS("110003", "Context has no parameters "),
    FLOW_CHK_INVALID("110004", "Flow inspection failed"),
    FLOW_RUN_EXCEPTION("110005", "Flow aborted"),
    FLOW_ID_IS_EMPTY("110006", "Flow Id is empty"),
    FLOW_ID_IS_EXIST("110007", "Duplicate flow id"),
    FLOW_URL_IS_EXIST("110008", "URI is exist"),
    FLOW_TOOL_IS_NOT("1100009", "PACKAGE TOOL IS NOT FOUND"),
    INVOKE_CALL_CLASSNOTFOUND("130001", "Class information not found"),
    INVOKE_CALL_NOSUCHMETHOD("130002", "Method not found"),
    INVOKE_CALL_ILLEGALACCESS("130003", "Method has no access"),
    INVOKE_CALL_ILLEGALARGUMENT("130004", "Invalid number or type of parameters"),
    INVOKE_CALL_FAILED("130005", "Method execution exception"),
    PARAM_CONVERT_ERROR("130006", "Parameter conversion error"),
    PARAM_VALIDATOR_ERROR("130007", "Parameter validator error"),
    ZK_INIT_ERROR("140001", "ZK configuration error"),
    ZK_NOT_GET_LOCK("140002", "Not get lock"),
    ZK_LOCK_TIMEOUT("140003", "Get lock timeout"),
    RSA_INIT_ERROR("150001", "RSA initialization exception"),
    RSA_PUBLICKEY_ERROR("150002", "Public key encryption and decryption aborted"),
    RSA_PRIVATEKEY_ERROR("150003", "Private key encryption and decryption aborted"),
    SCRIPT_EXECUTE_FAILED("150004", "Dynamic script execution exception"),
    SUBFLOW_NOT_FOUND("150005", "Subflow not found"),
    COMMON_FLOW_NOT_FOUND("150006", "Common flow not found"),
    TRANSITION_EXCP_EXCEPTION("150007", "Exception transfer matching exception"),
    TRANSITION_ANALYZE_EXCEPTION("150008", "Condition analysis exception"),
    TRANSITION_NO_POINT_CODE("150009", "The point code is not configured for transfer"),
    CONCURRENT_NOT_ASYNC("160001", "Parallel components cannot have asynchronous properties"),
    CONCURRENT_END_HAVE_EXISTED("160002", "The parallel component already exists, ending the component"),
    URL_ANALYZE_EXCEPTION("170001", "Not found "),
    ENV_NOT_FOUND("170002", "Environment not found"),
    BEAN_COPY_ERROR("170002", "Bean copy error"),
    NOT_FOUND_VALUE("200001", " The value was not found in Map"),
    SQL_ANALYZING_ERROR("200002", "SQL parsing error"),
    BSP_ANALYZING_ERROR("200003", "BSP parsing error"),
    BSP_FLOW_ERROR("200004", "BSP choreography configuration error"),
    SPEL_ANALYZING_ERROR("200005", "SPEL parsing error"),
    CLASS_IS_INTERFACE("200006", "Class is Interface"),
    BSP_RESULT_NOT_MAP("200007", "Result is not Map"),
    COMPILE_EXCEPTION("300000", "compile exception"),
    COMPILE_CLASS_NOT_FOUND("300001", "class not found");

    private String errorCode;
    private String errorMessage;

    private Error(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void throwNow() {
        throw new FeeException(this.errorCode, this.errorMessage);
    }

    public FeeException expcetion() {
        String traceInfo = this.createTraceInfo();
        String head = this.createHead();
        StringBuilder builder = new StringBuilder();
        builder.append(head);
        builder.append(this.errorMessage);
        FeeException ex = new FeeException(this.errorCode, builder.toString());
        ex.setTraceInfo(traceInfo);
        return ex;
    }

    public FeeException expcetion(String message) {
        String traceInfo = this.createTraceInfo();
        String head = this.createHead();
        StringBuilder builder = new StringBuilder();
        if (!message.startsWith(head)) {
            builder.append(head);
        }
        builder.append(this.errorMessage);
        builder.append(",");
        builder.append(message);
        FeeException ex = new FeeException(this.errorCode, builder.toString());
        ex.setTraceInfo(traceInfo);
        return ex;
    }

    private String createHead() {
        StringBuilder builder = new StringBuilder();
        if (MdcParamUtil.getParam("_flowId") != null) {
            builder.append("[");
            builder.append(MdcParamUtil.getParam("_flowId"));
            builder.append("]");
        }
        if (MdcParamUtil.getParam("_actionId") != null) {
            builder.append("[");
            builder.append(MdcParamUtil.getParam("_actionId"));
            builder.append("]");
        }
        return builder.toString();
    }

    private String createTraceInfo() {
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        int index = stacks.length >= 3 ? 3 : stacks.length - 1;
        return String.format("file[%s] class[%s] method[%s] Line[%d]", stacks[index].getFileName(), stacks[index].getClassName(), stacks[index].getMethodName(), stacks[index].getLineNumber());
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

