/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.util;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext = null;

    public static void clearHolder() {
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T getBeanIfExist(Class<T> requiredType) {
        try {
            return (T)applicationContext.getBean(requiredType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static Object getBeanIfExist(String name) {
        try {
            if (!StringUtils.isEmpty((Object)name.trim()) && applicationContext.containsBean(name)) {
                return applicationContext.getBean(name);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        try {
            return applicationContext.getBeansOfType(requiredType);
        }
        catch (Exception e) {
            return null;
        }
    }
}

