/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkgUtil {
    private static final Logger logger = LoggerFactory.getLogger(PkgUtil.class);

    public static Set<Class<?>> getClzFromPkg(String pkg) {
        LinkedHashSet classes = new LinkedHashSet();
        String pkgDirName = pkg.replace('.', '/');
        try {
            Enumeration<URL> urls = PkgUtil.class.getClassLoader().getResources(pkgDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PkgUtil.findClassesByFile(pkg, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                PkgUtil.findClassesByJar(pkg, jar, classes);
            }
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
        return classes;
    }

    private static void findClassesByFile(String pkgName, String pkgPath, Set<Class<?>> classes) {
        File dir = new File(pkgPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith("class"));
        if (dirFiles == null || dirFiles.length == 0) {
            return;
        }
        for (File f : dirFiles) {
            if (f.isDirectory()) {
                PkgUtil.findClassesByFile(pkgName + "." + f.getName(), pkgPath + "/" + f.getName(), classes);
                continue;
            }
            String className = f.getName();
            className = className.substring(0, className.length() - 6);
            Class<?> clz = PkgUtil.loadClass(pkgName + "." + className);
            if (clz == null) continue;
            classes.add(clz);
        }
    }

    private static void findClassesByJar(String pkgName, JarFile jar, Set<Class<?>> classes) {
        String pkgDir = pkgName.replace(".", "/");
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            String className;
            Class<?> clazz;
            JarEntry jarEntry = entry.nextElement();
            String name = jarEntry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (jarEntry.isDirectory() || !name.startsWith(pkgDir) || !name.endsWith(".class") || (clazz = PkgUtil.loadClass((className = name.substring(0, name.length() - 6)).replace("/", "."))) == null) continue;
            classes.add(clazz);
        }
    }

    private static Class<?> loadClass(String fullClzName) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullClzName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }
}

