/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.util;

import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.serial.SerialClob;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void addSpringBean(Object bean, String beanName, ApplicationContext applicationContext) {
        Map<String, Object> map = BeanUtil.beanToMap4(bean);
        if (map == null) {
            return;
        }
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(bean.getClass());
        map.forEach((k, v) -> {
            if (k != null && v != null) {
                beanDefinitionBuilder.addPropertyValue(k, v);
            }
        });
        defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public static void mapToBean(Map<String, Object> map, Object bean) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = propertyDescriptor.getName();
                if (!map.containsKey(fieldName)) continue;
                Object value = map.get(fieldName);
                Method setter = propertyDescriptor.getWriteMethod();
                Class<?>[] type = setter.getParameterTypes();
                if (!type[0].isInstance(value)) continue;
                setter.invoke(bean, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void mapToBean2(Map<String, Object> map, Object bean) {
        try {
            BeanUtils.populate((Object)bean, map);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static Object mapToBean3(Map<String, Object> map, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object bean = clazz.newInstance();
            BeanUtils.populate(bean, map);
            return bean;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> beanToMap(Object bean) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = propertyDescriptor.getName();
                if ("class".equals(fieldName)) continue;
                Method getter = propertyDescriptor.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                map.put(fieldName, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> beanToMap2(Object bean) {
        try {
            return BeanUtils.describe((Object)bean);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static Map beanToMap3(Object bean) {
        return new BeanMap(bean);
    }

    public static Map<String, Object> beanToMap4(Object bean) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = propertyDescriptor.getName();
                Method getter = propertyDescriptor.getReadMethod();
                Method setter = propertyDescriptor.getWriteMethod();
                if (getter == null || setter == null) continue;
                Object value = getter.invoke(bean, new Object[0]);
                map.put(fieldName, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
        }
        return map;
    }

    public static final Object strToBean(String className, String value) throws Exception {
        Object obj = value;
        if ("java.lang.Object".equals(className)) {
            obj = value;
        } else if ("object".equalsIgnoreCase(value)) {
            obj = "java.lang.Object";
        } else if ("boolean".equalsIgnoreCase(className)) {
            obj = Boolean.parseBoolean(value);
        } else if ("byte".equalsIgnoreCase(className)) {
            obj = Byte.parseByte(value);
        } else if ("int".equalsIgnoreCase(className)) {
            obj = Integer.parseInt(value);
        } else if ("long".equalsIgnoreCase(className)) {
            obj = Long.parseLong(value);
        } else if ("double".equalsIgnoreCase(className)) {
            obj = Double.parseDouble(value);
        } else if ("float".equalsIgnoreCase(className)) {
            obj = Float.valueOf(Float.parseFloat(value));
        } else if ("short".equalsIgnoreCase(className)) {
            obj = Short.parseShort(value);
        } else if ("java.lang.Boolean".equalsIgnoreCase(className)) {
            obj = Boolean.valueOf(value);
        } else if ("java.lang.Byte".equalsIgnoreCase(className)) {
            obj = Byte.valueOf(value);
        } else if ("java.lang.Integer".equalsIgnoreCase(className)) {
            obj = Integer.valueOf(value);
        } else if ("java.lang.Long".equalsIgnoreCase(className)) {
            obj = Long.valueOf(value);
        } else if ("java.lang.Double".equalsIgnoreCase(className)) {
            obj = Double.valueOf(value);
        } else if ("java.lang.Float".equalsIgnoreCase(className)) {
            obj = Float.valueOf(value);
        } else if ("java.math.BigDecimal".equalsIgnoreCase(className)) {
            obj = BigDecimal.valueOf(Double.valueOf(value));
        } else if ("java.lang.Short".equalsIgnoreCase(className)) {
            obj = Short.valueOf(value);
        } else if ("java.sql.Date".equalsIgnoreCase(className)) {
            obj = Date.valueOf(value);
        } else if ("java.util.Date".equalsIgnoreCase(className)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            obj = format.parse(value);
        } else if ("java.sql.Timestamp".equalsIgnoreCase(className)) {
            obj = Timestamp.valueOf(value);
        } else if ("java.sql.Clob".equalsIgnoreCase(className)) {
            obj = new SerialClob(value.toCharArray());
        } else if ("java.lang.Class".equalsIgnoreCase(className) || "class".equalsIgnoreCase(className)) {
            obj = ClassUtil.strToClass((String)value);
        } else if ("java.lang.Character".equalsIgnoreCase(className)) {
            obj = Character.valueOf(value.charAt(0));
        } else if ("char".equalsIgnoreCase(className)) {
            obj = Character.valueOf(value.charAt(0));
        }
        return obj;
    }

    public static <T> T map2Bean(Map<String, String> map, Class<T> class1) {
        T bean = null;
        try {
            bean = class1.newInstance();
            BeanUtils.populate(bean, map);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.warn("", (Throwable)e);
        }
        return bean;
    }

    public static boolean isJavaClass(Class<?> clz) {
        return clz != null && clz.getClassLoader() == null;
    }
}

