/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.ServiceCombProcess;
import cn.com.yusys.yusp.commons.fee.common.ThreadLocalClean;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.operation.TransactionOperations;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.MainFlowProcess;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ProcessCoord {
    @Autowired(required=false)
    private ServiceCombProcess serviceCombProcess;
    @Autowired(required=false)
    private TransactionOperations feeTransactionManager;
    @Autowired
    private MainFlowProcess mainFlowProcess;

    public Object processExecute(Flow flow) throws Exception {
        try {
            Object data = null;
            if (StringUtils.isEmpty((Object)flow.getServiceCombType())) {
                data = this.mainFlowProcess.process(flow);
            } else {
                FlowUtil.setSAGACurrentFlow((Flow)flow);
                if (this.serviceCombProcess != null) {
                    data = this.serviceCombProcess.getFlowProcess(flow.getServiceCombType()).process(flow);
                }
            }
            if (!ObjectUtils.isEmpty((Object)this.feeTransactionManager)) {
                this.feeTransactionManager.allCommit(ActionRunTimeHolder.getTransitionList());
            }
            Object object = data;
            return object;
        }
        catch (Exception ex) {
            if (!ObjectUtils.isEmpty((Object)this.feeTransactionManager)) {
                this.feeTransactionManager.allRollback(ActionRunTimeHolder.getTransitionList());
            }
            throw ex;
        }
        finally {
            ActionRunTimeHolder.removeAll();
            this.clearThreadLocal();
        }
    }

    private void clearThreadLocal() throws Exception {
        Map threadLocalCleans = SpringContextHolder.getBeansOfType(ThreadLocalClean.class);
        if (threadLocalCleans != null && !threadLocalCleans.isEmpty()) {
            for (Map.Entry entry : threadLocalCleans.entrySet()) {
                ((ThreadLocalClean)entry.getValue()).clear();
            }
        }
    }
}

