/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.LoopStatusType;
import cn.com.yusys.yusp.commons.fee.common.enums.TransactionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.LocalMark;
import cn.com.yusys.yusp.commons.fee.core.component.action.FlowEndAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.IFlowAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.LogicAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.StepAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.StepEndAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.StepFailedAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopEndAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopStatus;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopStatusManager;
import cn.com.yusys.yusp.commons.fee.core.component.flow.FlowHelper;
import cn.com.yusys.yusp.commons.fee.core.process.AbstractActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MainActionProcess
extends AbstractActionProcess {
    private static ThreadLocal<HashSet<Object>> SUB_TRANSACTIONS = ThreadLocal.withInitial(HashSet::new);
    private static final Logger logger = LoggerFactory.getLogger(MainActionProcess.class);

    @Override
    public void process(Action action, Context context) throws Exception {
        Action next;
        Object status;
        block11: {
            logger.info("               Start executing: component [{}].{}", (Object)action.getId(), (Object)action.getDescription());
            if (!ObjectUtils.isEmpty((Object)context.getProperty("logs"))) {
                ((List)context.getProperty("logs")).add("               Start executing: component [" + action.getId() + "]." + action.getDescription());
            }
            if (this.isEnd(action, context)) {
                this.executeAction(action, context);
                return;
            }
            status = null;
            try {
                status = this.doBegin(action);
                this.executeAction(action, context);
                this.commit(context, action, status);
                next = this.next(action, context, null);
            }
            catch (Exception e) {
                context.setException(e);
                logger.error("               Exceution exception: [{}].{} message:{}", new Object[]{action.getId(), action.getDescription(), e});
                next = this.next(action, context, e);
                if (next != null || !action.isThrowException()) break block11;
                this.subTransactionRollback(context);
                this.rollback(action, status);
                throw e;
            }
        }
        if (next == null) {
            Flow flow;
            Action endAction;
            if (action instanceof StepAction && Objects.isNull(endAction = FlowHelper.getAction(ActionNodeType.END, (flow = this.factory.getFlow((String)context.getProperty("_flowId"))).getActions()))) {
                next = new FlowEndAction();
            }
            if (action instanceof StepEndAction || action instanceof StepFailedAction) {
                return;
            }
        }
        if (next == null) {
            this.subTransactionRollback(context);
            this.rollback(action, status);
            if (action.isThrowException()) {
                throw Error.ACTION_NEXT_NULL.expcetion();
            }
            next = this.next(action, context, null);
        }
        if (next instanceof LogicAction && ((LogicAction)next).getCallMethod().equalsIgnoreCase("dispatchMessage") && ((LogicAction)next).getCallClassName().equalsIgnoreCase("cn.com.yusys.yusp.commons.fee.logic.mq.MQListenerComponent")) {
            next = new FlowEndAction();
        }
        logger.info("               Next component: [{}].{}", (Object)next.getId(), (Object)next.getDescription());
        if (!ObjectUtils.isEmpty((Object)context.getProperty("logs"))) {
            ((List)context.getProperty("logs")).add("               Next component: [" + next.getId() + "]." + next.getDescription());
        }
        this.getActionProcess(next).process(next, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnd(Action action, Context context) {
        if (LocalMark.isInterrupt().booleanValue()) {
            try {
                this.subTransactionCommit(context);
                logger.info("Interrupt and exit");
                boolean bl = true;
                return bl;
            }
            finally {
                LocalMark.removeInterrupt();
            }
        }
        if (action.isCloseable()) {
            this.subTransactionCommit(context);
            if (action instanceof LoopEndAction) {
                LoopEndAction loopEndAction = (LoopEndAction)action;
                LoopStatus loopStatus = LoopStatusManager.getCurrent();
                if (loopEndAction.isStop()) {
                    loopStatus.setStatusType(LoopStatusType.STOP);
                }
            }
            return true;
        }
        return false;
    }

    private void commit(Context context, Action currentAction, Object status) {
        if (StringUtils.isEmpty((Object)currentAction.getTransaction())) {
            return;
        }
        if (this.isSubFlow(context)) {
            if (ActionNodeType.MAPPER.getValue().equals(currentAction.getNodeType())) {
                SUB_TRANSACTIONS.get().add(status);
            }
        } else {
            this.commit(currentAction, status);
        }
    }

    private boolean isSubFlow(Context context) {
        if (context.containsPropertyKey("_mainSubFlowActionId")) {
            IFlowAction mainSubFlowAction = (IFlowAction)context.getProperty("_mainSubFlowActionId");
            return mainSubFlowAction != null;
        }
        return false;
    }

    private void subTransactionRollback(Context context) {
        if (this.isSubFlow(context) && !SUB_TRANSACTIONS.get().isEmpty()) {
            IFlowAction mainSubFlowAction = (IFlowAction)context.getProperty("_mainSubFlowActionId");
            if (TransactionType.NEW.getValue().equals(mainSubFlowAction.getTransaction())) {
                this.allRollback(SUB_TRANSACTIONS.get());
            }
            if (TransactionType.REQUIRED.getValue().equals(mainSubFlowAction.getTransaction())) {
                if (mainSubFlowAction.isAsync()) {
                    this.allRollback(SUB_TRANSACTIONS.get());
                }
                SUB_TRANSACTIONS.get().forEach(ActionRunTimeHolder::addTransaction);
            }
            SUB_TRANSACTIONS.remove();
            context.removeProperty("_mainSubFlowActionId");
        }
    }

    private void subTransactionCommit(Context context) {
        if (this.isSubFlow(context) && !SUB_TRANSACTIONS.get().isEmpty()) {
            IFlowAction mainSubFlowAction = (IFlowAction)context.getProperty("_mainSubFlowActionId");
            if (TransactionType.NEW.getValue().equals(mainSubFlowAction.getTransaction())) {
                this.allCommit(SUB_TRANSACTIONS.get());
            }
            if (TransactionType.REQUIRED.getValue().equals(mainSubFlowAction.getTransaction())) {
                SUB_TRANSACTIONS.get().forEach(commitStatus -> {
                    if (mainSubFlowAction.isAsync()) {
                        this.commit(mainSubFlowAction, commitStatus);
                    } else {
                        ActionRunTimeHolder.addTransaction(commitStatus);
                    }
                });
            }
            SUB_TRANSACTIONS.remove();
            context.removeProperty("_mainSubFlowActionId");
        }
    }

    @Override
    public ProcessType getProcessType() {
        return ProcessType.MAIN;
    }
}

