/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.enums.TransactionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentStartAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.MybatisAction;
import cn.com.yusys.yusp.commons.fee.core.process.AbstractActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessType;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConcurrentActionProcess
extends AbstractActionProcess {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConcurrentActionProcess.class);

    @Override
    public void process(Action action, Context context) throws Exception {
        if (action.isAsync()) {
            throw Error.CONCURRENT_NOT_ASYNC.expcetion();
        }
        String flowId = (String)context.getProperty("_flowId");
        try {
            Callable<Object> actionCall = () -> {
                try {
                    MdcParamUtil.initParam((String)"_flowId", (String)flowId);
                    if (action instanceof MybatisAction && !TransactionType.NEW.getValue().equals(action.getTransaction())) {
                        ((MybatisAction)action).setTransaction(TransactionType.NEW.getValue());
                    }
                    this.getActionProcess(action).process(action, context);
                }
                catch (Throwable ex) {
                    logger.error("Asynchronous task execution exception", ex);
                    throw Error.ACTION_ASYNC_FAILED.expcetion(ex.getMessage());
                }
                finally {
                    MdcParamUtil.cleanParam((String)"_flowId");
                }
                return null;
            };
            ConcurrentStartAction thisConcurrentStartAction = ActionRunTimeHolder.getThisConcurrentStartAction();
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future<Object> future = executorService.submit(actionCall);
            Queue futures = ActionRunTimeHolder.getCurrentMap().getOrDefault(thisConcurrentStartAction.getId(), new ConcurrentLinkedDeque());
            futures.add(future);
            ActionRunTimeHolder.addFuture(thisConcurrentStartAction.getId(), futures);
        }
        catch (Exception e) {
            throw Error.ACTION_ASYNC_FAILED.expcetion(e.getMessage());
        }
    }

    @Override
    public ProcessType getProcessType() {
        return ProcessType.CONCURRENT;
    }
}

