/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.enums.PointCode;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentStartAction;
import java.util.HashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ActionRunTimeHolder {
    private static ThreadLocal<HashSet<Object>> TRANSACTIONSTATUS_LIST = ThreadLocal.withInitial(HashSet::new);
    private static ThreadLocal<ConcurrentHashMap<String, Queue<Future>>> CURRENT_LIST = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static ThreadLocal<String> CONCURRENT_BEGIN_ID = new ThreadLocal();
    private static ThreadLocal<ConcurrentStartAction> thisConcurrentStartAction = new ThreadLocal();
    private static final ThreadLocal<Integer> pointHolder = new ThreadLocal();

    private ActionRunTimeHolder() {
    }

    public static ConcurrentStartAction getThisConcurrentStartAction() {
        return thisConcurrentStartAction.get();
    }

    public static void setThisConcurrentStartAction(ConcurrentStartAction concurrentStartAction) {
        thisConcurrentStartAction.set(concurrentStartAction);
    }

    public static String getConcurrentBeginId() {
        return CONCURRENT_BEGIN_ID.get();
    }

    public static void removeConcurrentBeginId() {
        CONCURRENT_BEGIN_ID.remove();
    }

    public static void setConcurrentBeginId(String id) {
        CONCURRENT_BEGIN_ID.set(id);
    }

    public static ConcurrentHashMap<String, Queue<Future>> getCurrentMap() {
        return CURRENT_LIST.get();
    }

    public static void addFuture(String concurrentStartId, Queue<Future> future) {
        CURRENT_LIST.get().put(concurrentStartId, future);
    }

    public static void removeFuture() {
        CURRENT_LIST.remove();
    }

    public static void setTransactionStatus(HashSet<Object> statusSet) {
        TRANSACTIONSTATUS_LIST.set(statusSet);
    }

    public static void addTransaction(Object status) {
        TRANSACTIONSTATUS_LIST.get().add(status);
    }

    public static HashSet<Object> getTransitionList() {
        return TRANSACTIONSTATUS_LIST.get();
    }

    public static void removeTransitionList() {
        TRANSACTIONSTATUS_LIST.remove();
    }

    public static void removeAll() {
        pointHolder.remove();
        TRANSACTIONSTATUS_LIST.remove();
        CURRENT_LIST.remove();
        CONCURRENT_BEGIN_ID.remove();
        MdcParamUtil.cleanParam((String)"_flowId");
    }

    public static void setPoint(int point) {
        pointHolder.set(point);
    }

    public static int getPoint() {
        Integer point = pointHolder.get();
        return Objects.isNull(point) ? PointCode.SUCCESS.getCode() : point.intValue();
    }

    public static boolean existsPoint() {
        return Objects.nonNull(pointHolder.get());
    }

    public static void removePoint() {
        pointHolder.remove();
    }
}

