/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init;

import cn.com.yusys.yusp.commons.fee.common.annotation.XmlNode;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.core.util.PkgUtil;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class TagDefinitionMapping {
    private static Map<String, Class<? extends Definition>> mapping = new WeakHashMap<String, Class<? extends Definition>>();
    private static TagDefinitionMapping tagDefinitionMapping = new TagDefinitionMapping();

    private TagDefinitionMapping() {
    }

    public static TagDefinitionMapping getInstance() {
        return tagDefinitionMapping;
    }

    private synchronized void loadMapping() {
        Set<Class<?>> classes = PkgUtil.getClzFromPkg("cn.com.yusys.yusp.commons.fee.core.init.definition");
        classes.forEach(e -> {
            if (Definition.class.isAssignableFrom((Class<?>)e) && e.isAnnotationPresent(XmlNode.class)) {
                XmlNode xmlNode = e.getAnnotation(XmlNode.class);
                mapping.put(xmlNode.value(), (Class<? extends Definition>)e);
            }
        });
    }

    public boolean hasDefinition(String tagName) {
        if (mapping.isEmpty()) {
            this.loadMapping();
        }
        return mapping.containsKey(tagName);
    }

    public Class<? extends Definition> getDefinition(String tagName) {
        if (mapping.isEmpty()) {
            this.loadMapping();
        }
        return mapping.get(tagName);
    }
}

