/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init;

import cn.com.yusys.yusp.commons.fee.common.enums.ControllerMethod;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.api.rest.FeeAccessController;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class MappingService {
    private static final Logger logger = LoggerFactory.getLogger(MappingService.class);
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private FeeAccessController feeAccessController;

    public void addAllMapping() {
        Set<String> getUrls = this.flowDefinitionRegistry.getUrls("GET");
        getUrls.forEach(e -> {
            this.addMapping(ControllerMethod.GET_ACCESS, (String)e);
            logger.info("FEE api registered successfully, url={}, method=GET", e);
        });
        Set<String> postUrls = this.flowDefinitionRegistry.getUrls("POST");
        postUrls.forEach(e -> {
            this.addMapping(ControllerMethod.POST_ACCESS, (String)e);
            logger.info("FEE api registered successfully, url={}, method=POST", e);
        });
    }

    public void addMapping(ControllerMethod methodEnum, String path) {
        try {
            switch (methodEnum) {
                case POST_ACCESS: {
                    RequestMappingInfo requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.POST}).build();
                    if (requestMappingInfo == null) break;
                    this.requestMappingHandlerMapping.registerMapping(requestMappingInfo, (Object)this.feeAccessController, this.feeAccessController.getClass().getDeclaredMethod(methodEnum.getMethodName(), ObjectNode.class, HttpServletRequest.class, HttpServletResponse.class));
                    break;
                }
                case GET_ACCESS: {
                    RequestMappingInfo requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.GET}).build();
                    if (requestMappingInfo == null) break;
                    this.requestMappingHandlerMapping.registerMapping(requestMappingInfo, (Object)this.feeAccessController, this.feeAccessController.getClass().getDeclaredMethod(methodEnum.getMethodName(), Map.class, HttpServletRequest.class, HttpServletResponse.class));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.API_REGISTRY_ERROR.expcetion();
        }
    }

    public void removeMapping(RequestMappingInfo requestMappingInfo) {
        this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
    }
}

