/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init;

import cn.com.yusys.yusp.commons.fee.common.SwaggerHotLoad;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.fee.core.config.FeeProperties;
import cn.com.yusys.yusp.commons.fee.core.parsexml.factory.ClassLoaderFactory;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.XMLLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

public class DynamicLoader
implements SchedulingConfigurer,
InitializingBean {
    @Autowired
    private ApplicationProperties applicationProperties;
    private FeeProperties feeProperties;
    @Autowired(required=false)
    private SwaggerHotLoad hotLoadSwagger;

    public void doRegistry() {
        XMLLoader loader = ClassLoaderFactory.getLoader(this.feeProperties.getFlowLocation());
        loader.doRegistryXML(this.feeProperties.getFlowLocation());
    }

    private void hotLoad() {
        this.doRegistry();
        if (this.hotLoadSwagger != null) {
            this.hotLoadSwagger.hotLoad();
        }
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (this.feeProperties.isHotDeploy()) {
            taskRegistrar.addTriggerTask(this::hotLoad, triggerContext -> new CronTrigger(this.feeProperties.getHotDeployCron()).nextExecutionTime(triggerContext));
        }
    }

    public void afterPropertiesSet() {
        this.feeProperties = this.applicationProperties.getFee();
    }
}

