/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.groovy;

import cn.com.yusys.yusp.commons.fee.common.enums.TemplateType;
import cn.com.yusys.yusp.commons.fee.core.groovy.ConditionOel;
import cn.com.yusys.yusp.commons.fee.core.groovy.ExpressionOel;
import cn.com.yusys.yusp.commons.fee.core.groovy.template.ConditionTemplate;
import cn.com.yusys.yusp.commons.fee.core.groovy.template.ExpressionTemplate;
import cn.com.yusys.yusp.commons.fee.core.groovy.template.JavaScriptTemplate;
import cn.com.yusys.yusp.commons.fee.core.groovy.template.Template;
import groovy.lang.GroovyClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OelFactory {
    private static final Logger logger = LoggerFactory.getLogger(OelFactory.class);
    private static Map<String, Object> GROOVY_CLASS_CACHE = new ConcurrentHashMap<String, Object>();
    private static Map<String, Template> TEMPLATE_MAP = new HashMap<String, Template>();
    private static OelFactory oelFactory = new OelFactory();
    private static AtomicInteger atomicInteger = new AtomicInteger(100);

    public static OelFactory getInstance() {
        return oelFactory;
    }

    public ConditionOel getConditionInstance(String el) throws Exception {
        if (!GROOVY_CLASS_CACHE.containsKey(el)) {
            return this.loadConditionInstance(el);
        }
        return (ConditionOel)GROOVY_CLASS_CACHE.get(el);
    }

    public ExpressionOel getExpressionInstance(String el) throws Exception {
        if (!GROOVY_CLASS_CACHE.containsKey(el)) {
            return this.loadExpressionInstance(el);
        }
        return (ExpressionOel)GROOVY_CLASS_CACHE.get(el);
    }

    public ExpressionOel getJavaScriptInstance(String el) throws Exception {
        if (!GROOVY_CLASS_CACHE.containsKey(el)) {
            return this.loadJavaScriptInstance(el);
        }
        return (ExpressionOel)GROOVY_CLASS_CACHE.get(el);
    }

    public ExpressionOel loadJavaScriptInstance(String el) throws Exception {
        Template template = TEMPLATE_MAP.get(TemplateType.JAVASCRIPT.getValue());
        String className = Template.createClassName(TemplateType.JAVASCRIPT.getClassTemplateName(), atomicInteger.incrementAndGet());
        return (ExpressionOel)this.loadInstance(el, className, template);
    }

    public ExpressionOel loadExpressionInstance(String el) throws Exception {
        Template template = TEMPLATE_MAP.get(TemplateType.EXPRESSION.getValue());
        String className = Template.createClassName(TemplateType.EXPRESSION.getClassTemplateName(), atomicInteger.incrementAndGet());
        return (ExpressionOel)this.loadInstance(el, className, template);
    }

    public ConditionOel loadConditionInstance(String el) throws Exception {
        Template template = TEMPLATE_MAP.get(TemplateType.CONDITION.getValue());
        String className = Template.createClassName(TemplateType.CONDITION.getClassTemplateName(), atomicInteger.incrementAndGet());
        return (ConditionOel)this.loadInstance(el, className, template);
    }

    public Object loadInstance(String el, String className, TemplateType templateType) throws Exception {
        Template template = TEMPLATE_MAP.get(templateType.getValue());
        return this.loadInstance(el, className, template);
    }

    public void putInstance(String el, ConditionOel condition) throws Exception {
        GROOVY_CLASS_CACHE.put(el, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadInstance(String el, String className, Template template) throws Exception {
        OelFactory oelFactory = this;
        synchronized (oelFactory) {
            if (GROOVY_CLASS_CACHE.containsKey(el)) {
                return GROOVY_CLASS_CACHE.get(el);
            }
            try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader();){
                Class clazz;
                String codeSource = template.template(el, className);
                if (logger.isDebugEnabled()) {
                    logger.debug("Code fragment[{}]", (Object)codeSource);
                }
                if ((clazz = groovyClassLoader.parseClass(codeSource)) == null) return null;
                Object instance = clazz.newInstance();
                if (instance == null) return null;
                logger.info("el expression[{}], ClassName[{}], load success!!", (Object)el, (Object)className);
                GROOVY_CLASS_CACHE.put(el, instance);
                Object t = instance;
                return t;
            }
            catch (Exception ex) {
                logger.error("Dynamic code fragment load failed, [Condition], expression [{}], [{}]", (Object)el, (Object)className);
                logger.error("", (Throwable)ex);
                throw ex;
            }
        }
    }

    static {
        ConditionTemplate conditionTemplate = new ConditionTemplate();
        ExpressionTemplate expressionTemplate = new ExpressionTemplate();
        JavaScriptTemplate javaScriptTemplate = new JavaScriptTemplate();
        TEMPLATE_MAP.put(conditionTemplate.getType().getValue(), conditionTemplate);
        TEMPLATE_MAP.put(expressionTemplate.getType().getValue(), expressionTemplate);
        TEMPLATE_MAP.put(javaScriptTemplate.getType().getValue(), javaScriptTemplate);
    }
}

