/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.executor;

import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.fee.core.config.AsyncProperies;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorPool {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorPool.class);
    private static Map<String, ExecutorService> localPool = new ConcurrentHashMap<String, ExecutorService>();

    public static void execute(String groupName, Runnable runnable) {
        if (localPool.get(groupName) == null) {
            ExecutorPool.initExecutor(groupName);
        }
        localPool.get(groupName).execute(runnable);
    }

    public static Future<?> execute(String groupName, Callable<?> callable) {
        if (localPool.get(groupName) == null) {
            ExecutorPool.initExecutor(groupName);
        }
        return localPool.get(groupName).submit(callable);
    }

    public static void initExecutor(String groupName) {
        ApplicationProperties applicationProperties = (ApplicationProperties)SpringContextHolder.getBeanIfExist(ApplicationProperties.class);
        if (applicationProperties != null) {
            ExecutorPool.initExecutor(groupName, applicationProperties.getAsync());
        } else {
            ExecutorPool.initExecutor(groupName, new AsyncProperies());
        }
    }

    public static void initExecutor(String groupName, AsyncProperies asyn) {
        if (localPool.containsKey(groupName)) {
            logger.info("Thread pool already exists, groupName[{}]", (Object)groupName);
            return;
        }
        localPool.put(groupName, ExecutorPool.createExecutor(asyn));
        logger.info("Thread pool initialization completed, groupName[{}], parameter configuration{}", (Object)groupName, (Object)asyn);
    }

    private static ExecutorService createExecutor(AsyncProperies async) {
        return new ThreadPoolExecutor(async.getCorePoolSize(), async.getMaxPoolSize(), async.getKeepAliveTime(), TimeUnit.MILLISECONDS, ExecutorPool.getBlockingQueue(async.getQueueCapacity()));
    }

    public static void shutdown() {
        for (ExecutorService executor : localPool.values()) {
            executor.shutdownNow();
        }
        localPool.clear();
        logger.info("Thread pool destroy completed.");
    }

    public static BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        if (maxQueueSize <= 0) {
            return new SynchronousQueue<Runnable>();
        }
        return new LinkedBlockingQueue<Runnable>(maxQueueSize);
    }
}

