/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.exception;

import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ExceptionConfigAdapter {
    private static Logger logger = LoggerFactory.getLogger(ExceptionConfigAdapter.class);
    private static final String EXCEPTION_CONFIG_PATH = "config/exceptionConfig/config.properties";

    public static void loadExceptionConfigCache() {
        ExceptionConfigAdapter.loadProperties();
    }

    private static void loadProperties() {
        try {
            Properties pro = PropertiesLoaderUtils.loadAllProperties((String)EXCEPTION_CONFIG_PATH);
            for (Map.Entry<Object, Object> entry : pro.entrySet()) {
                String applicationExceptionCode = URLDecoder.decode((String)entry.getValue(), "GBK");
                String feeExceptionCode = URLDecoder.decode((String)entry.getKey(), "GBK");
                FlowUtil.putExceptionConfigMap((String)feeExceptionCode, (String)applicationExceptionCode);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw Error.INNER_ERROR.expcetion();
        }
    }
}

