/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.config;

import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.FeeRunner;
import cn.com.yusys.yusp.commons.fee.core.api.IdempotentProcessor;
import cn.com.yusys.yusp.commons.fee.core.api.rest.FeeAccessController;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.component.FeeClientHttpRequestInterceptor;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.fee.core.config.FeeImportSelector;
import cn.com.yusys.yusp.commons.fee.core.init.DynamicLoader;
import cn.com.yusys.yusp.commons.fee.core.init.FeeInit;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.MappingService;
import cn.com.yusys.yusp.commons.fee.core.init.XmlLoaderRegister;
import cn.com.yusys.yusp.commons.fee.core.init.parse.FlowParser;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.FileLoader;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.JarLoader;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessCoord;
import java.nio.charset.Charset;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={ApplicationProperties.class})
@Import(value={FeeImportSelector.class})
public class FeeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"springContextHolder"})
    public FeeInit feeInit() {
        return new FeeInit();
    }

    @Bean
    @ConditionalOnMissingBean
    public FlowParser flowParser() {
        return new FlowParser();
    }

    @Bean
    @ConditionalOnMissingBean
    public FlowDefinitionRegistry flowDefinitionRegistry() {
        return new FlowDefinitionRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public ComponentFactory componentFactory() {
        return new ComponentFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingService mappingService() {
        return new MappingService();
    }

    @Bean
    @ConditionalOnMissingBean
    public FeeAccessController feeAccessController() {
        return new FeeAccessController();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicLoader feeClassLoader() {
        return new DynamicLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public XmlLoaderRegister classLoaderSupport() {
        return new XmlLoaderRegister();
    }

    @Bean
    @ConditionalOnMissingBean
    public FeeRunner feeRunner() {
        return new FeeRunner();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProcessCoord processCoord() {
        return new ProcessCoord();
    }

    @Bean
    @ConditionalOnMissingBean
    public IdempotentProcessor IdempotentProcessor() {
        return new IdempotentProcessor();
    }

    @Bean(name={"feeresttemplate"})
    @LoadBalanced
    public RestTemplate feeRestTemplate() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(10000);
        requestFactory.setReadTimeout(10000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        restTemplate.setInterceptors(Collections.singletonList(this.feeClientHttpRequestInterceptor()));
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public FeeClientHttpRequestInterceptor feeClientHttpRequestInterceptor() {
        return new FeeClientHttpRequestInterceptor();
    }

    @Bean
    public JarLoader jarLoader() {
        return new JarLoader();
    }

    @Bean
    public FileLoader fileLoader() {
        return new FileLoader();
    }
}

