/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.transition;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Transition;
import cn.com.yusys.yusp.commons.fee.common.enums.TransitionType;
import cn.com.yusys.yusp.commons.fee.core.component.transition.Analyze;
import cn.com.yusys.yusp.commons.fee.core.component.transition.AnalyzeFactory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TransitionFactory {
    public static Transition choose(List<Transition> transitions, Context context, Throwable able, TransitionType transitionType) {
        Analyze analyze;
        if (transitions == null || 0 == transitions.size()) {
            return null;
        }
        if (!Objects.equals(transitionType, TransitionType.INNER)) {
            for (Transition transition : transitions) {
                if (!Objects.equals(TransitionType.POINTS.getValue(), transition.getType()) || (analyze = AnalyzeFactory.getAnalyze(TransitionType.POINTS)) == null || !analyze.match(transition.getCondition(), context, able)) continue;
                return transition;
            }
        }
        for (Transition transition : transitions) {
            if (!transitionType.getValue().equals(transition.getType()) || (analyze = AnalyzeFactory.getAnalyze(transitionType)) == null || !analyze.match(transition.getCondition(), context, able)) continue;
            return transition;
        }
        return null;
    }

    public static Transition chooseNormal(List<Transition> transitions, Context context) {
        return TransitionFactory.choose(transitions, context, null, TransitionType.NORMAL);
    }

    public static Transition chooseExcep(List<Transition> transitions, Context context, Throwable able) {
        return TransitionFactory.choose(transitions, context, able, TransitionType.EXCEPTION);
    }

    public static Transition choosePoints(List<Transition> transitions, Context context) {
        return TransitionFactory.choose(transitions, context, null, TransitionType.POINTS);
    }

    public static List<Transition> chooseConcurrent(List<Transition> transitions) {
        if (transitions == null || 0 == transitions.size()) {
            return null;
        }
        return transitions.stream().filter(s -> TransitionType.CONCURRENT.getValue().equals(s.getType())).collect(Collectors.toList());
    }

    public static Transition chooseLoop(List<Transition> transitions, Context context) {
        return TransitionFactory.choose(transitions, context, null, TransitionType.LOOP);
    }

    public static Transition chooseInner(List<Transition> transitions, Context context) {
        return TransitionFactory.choose(transitions, context, null, TransitionType.INNER);
    }

    public static boolean checkConcurrent(List<Transition> transitions) {
        if (transitions == null || 0 == transitions.size()) {
            return false;
        }
        return transitions.stream().anyMatch(s -> TransitionType.CONCURRENT.getValue().equals(s.getType()));
    }
}

