/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.transition;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.core.component.transition.Analyze;
import cn.com.yusys.yusp.commons.fee.core.groovy.OelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalAnalyze
implements Analyze {
    private static final Logger logger = LoggerFactory.getLogger(NormalAnalyze.class);

    @Override
    public boolean match(String condition, Context context, Throwable able) {
        if (condition == null || "".equals(condition)) {
            if (logger.isDebugEnabled()) {
                logger.debug("General conditions, direct transfer.");
            }
            return true;
        }
        try {
            boolean result = OelFactory.getInstance().getConditionInstance(condition).match(context);
            if (logger.isDebugEnabled()) {
                logger.debug("Condition[{}], validation result is [{}].", (Object)condition, (Object)result);
            }
            return result;
        }
        catch (FeeException e) {
            logger.error("Condition[{}], el parsing exception, error message", (Object)condition, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Condition[{}], el parsing exception, error message", (Object)condition, (Object)e);
            Throwable throwable = e.getCause();
            if (throwable instanceof FeeException) {
                throw (FeeException)throwable;
            }
            throw Error.TRANSITION_ANALYZE_EXCEPTION.expcetion(e.getMessage());
        }
    }
}

