/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.transition;

import cn.com.yusys.yusp.commons.fee.common.enums.TransitionType;
import cn.com.yusys.yusp.commons.fee.core.component.transition.Analyze;
import cn.com.yusys.yusp.commons.fee.core.component.transition.ExceptionAnalyze;
import cn.com.yusys.yusp.commons.fee.core.component.transition.NormalAnalyze;
import cn.com.yusys.yusp.commons.fee.core.component.transition.PointCodeAnalyze;

public class AnalyzeFactory {
    private static NormalAnalyze normalAnalyze = new NormalAnalyze();
    private static ExceptionAnalyze exceptionAnalyze = new ExceptionAnalyze();
    private static PointCodeAnalyze pointCodeAnalyze = new PointCodeAnalyze();

    public static Analyze getAnalyze(TransitionType transitionType) {
        Analyze analyze = null;
        switch (transitionType) {
            case NORMAL: 
            case LOOP: 
            case INNER: {
                analyze = normalAnalyze;
                break;
            }
            case EXCEPTION: {
                analyze = exceptionAnalyze;
                break;
            }
            case POINTS: {
                analyze = pointCodeAnalyze;
            }
        }
        return analyze;
    }
}

