/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action.loop;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Transition;
import cn.com.yusys.yusp.commons.fee.common.enums.CollectionType;
import cn.com.yusys.yusp.commons.fee.common.enums.LoopStatusType;
import cn.com.yusys.yusp.commons.fee.common.enums.LoopType;
import cn.com.yusys.yusp.commons.fee.common.enums.TransitionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.component.action.abst.BaseAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopContext;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopStatus;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopStatusManager;
import cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopVariable;
import cn.com.yusys.yusp.commons.fee.core.component.transition.Analyze;
import cn.com.yusys.yusp.commons.fee.core.component.transition.AnalyzeFactory;
import cn.com.yusys.yusp.commons.fee.core.component.transition.TransitionFactory;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LoopAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(LoopAction.class);
    private String indexInit = "0";
    private int indexInitInt = 0;
    private String delta = "1";
    private int deltaInt = 1;
    private String stopCondition;
    private String collectionName;
    private String collectionType;
    private String loopType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Context context) throws Exception {
        LoopContext loopContext;
        this.checkAttributes(context);
        LoopType lType = LoopType.getTypeByName((String)this.loopType);
        CollectionType colType = CollectionType.getTypeByName((String)this.collectionType);
        Analyze analyze = AnalyzeFactory.getAnalyze(TransitionType.LOOP);
        LoopStatus loopStatus = new LoopStatus();
        loopStatus.setActionId(this.id);
        loopStatus.setStatusType(LoopStatusType.CONTINUE);
        LoopStatusManager.add(loopStatus);
        LoopVariable loopVariable = new LoopVariable();
        loopVariable.setIndex(this.indexInitInt);
        long count = loopVariable.getCount();
        Map properties = context.getProperties();
        if (properties.containsKey("loopContext")) {
            loopContext = (LoopContext)properties.get("loopContext");
        } else {
            loopContext = new LoopContext();
            context.putProperty("loopContext", (Object)loopContext);
        }
        loopContext.addChild(loopVariable);
        boolean stopLoop = false;
        try {
            while (!stopLoop) {
                if (loopStatus.getStatusType() == LoopStatusType.CONTINUE) {
                    stopLoop = this.loop(context, colType, lType);
                } else if (loopStatus.getStatusType() == LoopStatusType.STOP) {
                    stopLoop = true;
                }
                if (!stopLoop && !StringUtils.isEmpty((Object)this.stopCondition) && analyze.match(this.stopCondition, context, null)) {
                    stopLoop = true;
                }
                if (!stopLoop) {
                    Action firstLoopAction = this.getFirstLoopAction(context);
                    if (firstLoopAction != null) {
                        ProcessFactory.getProcess(firstLoopAction).process(firstLoopAction, context);
                    } else {
                        throw Error.NO_START_ACTION.expcetion("loop action missing start node");
                    }
                }
                loopVariable.setCount(++count);
            }
        }
        finally {
            LoopStatusManager.removeCurrent();
            loopContext.removeCurrent();
        }
        return null;
    }

    private LoopVariable getLoopVariable(Context context) {
        Map properties = context.getProperties();
        LoopContext loopContext = (LoopContext)properties.get("loopContext");
        return loopContext.getCurrent();
    }

    private Action getFirstLoopAction(Context context) {
        Map actionMap = this.factory.getFlow((String)context.getProperty("_flowId")).getActionMap();
        List<Transition> transitions = this.getTransitions();
        Action action = null;
        if (transitions == null || transitions.isEmpty()) {
            logger.warn("There is no transfer line for the loop component");
        } else {
            Transition transition = TransitionFactory.chooseLoop(transitions, context);
            if (transition == null) {
                logger.warn("Loop component has no matching loop transfer line, empty loop body!");
            } else {
                action = (Action)actionMap.get(transition.getTo());
            }
        }
        return action;
    }

    private void checkAttributes(Context context) {
        if (StringUtils.isEmpty((Object)this.loopType)) {
            logger.error("Loop component missing loop type: loopType");
            throw Error.ACTION_LACK_ATTRIBUTE.expcetion();
        }
        LoopType lType = LoopType.getTypeByName((String)this.loopType);
        if (lType == null) {
            logger.error("Unknown loop type: loopType={}", (Object)this.loopType);
            throw Error.ACTION_ATTRIBUTE_EXCEPTION.expcetion();
        }
        switch (lType) {
            case FOR: 
            case WHILE: {
                if (!StringUtils.isEmpty((Object)this.stopCondition)) break;
                logger.error("Loop component missing property: stopCondition, loop type: {}", (Object)lType.getName());
                throw Error.ACTION_LACK_ATTRIBUTE.expcetion();
            }
            case COLLECTION: {
                if (StringUtils.isEmpty((Object)this.collectionName)) {
                    logger.error("Loop component missing property: collectionName, loop type: {}", (Object)lType.getName());
                    throw Error.ACTION_LACK_ATTRIBUTE.expcetion();
                }
                if (StringUtils.isEmpty((Object)this.collectionType)) {
                    logger.error("Loop component missing property: collectionType, loop type: {}", (Object)lType.getName());
                    throw Error.ACTION_LACK_ATTRIBUTE.expcetion();
                }
                CollectionType colType = CollectionType.getTypeByName((String)this.collectionType);
                if (colType == null) {
                    logger.error("Loop component property exception: collectionType, loop type: {}", (Object)this.collectionType, (Object)lType.getName());
                    throw Error.ACTION_ATTRIBUTE_EXCEPTION.expcetion();
                }
                this.checkCollectType(colType, context.getParam(this.collectionName));
            }
        }
    }

    private void checkCollectType(CollectionType colType, Object collect) {
        if (collect == null) {
            logger.error("The set iterated by the loop component does not exist. Please check if the input parameter {} exists", (Object)this.collectionName);
            throw Error.CONTEXT_NO_PARAMS.expcetion();
        }
        boolean typeRight = false;
        switch (colType) {
            case LIST: {
                if (!(collect instanceof List)) break;
                typeRight = true;
                break;
            }
            case SET: {
                if (!(collect instanceof Set)) break;
                typeRight = true;
                break;
            }
            case MAP: {
                if (!(collect instanceof Map)) break;
                typeRight = true;
                break;
            }
            case ARRAY: {
                if (!collect.getClass().isArray()) break;
                typeRight = true;
            }
        }
        if (!typeRight) {
            logger.error("Set {} iterated by loop component does not match set type {}", (Object)this.collectionName, (Object)colType.getName());
            throw Error.ACTION_TYPE_EXCEPTION.expcetion();
        }
    }

    private boolean doFor(Context context) {
        this.incrIndex(context);
        return false;
    }

    private boolean doWhile(Context context) {
        this.incrIndex(context);
        return false;
    }

    private void incrIndex(Context context) {
        LoopVariable loopVariable = this.getLoopVariable(context);
        if (loopVariable.getCount() > 0L) {
            int index = loopVariable.getIndex();
            loopVariable.setIndex(index += this.deltaInt);
        }
    }

    private boolean incrIndex(int size, Context context) {
        LoopVariable loopVariable = this.getLoopVariable(context);
        if (loopVariable.getCount() > 0L) {
            int index = loopVariable.getIndex();
            if ((index += this.deltaInt) > size - 1) {
                return true;
            }
            loopVariable.setIndex(index);
        }
        return false;
    }

    private boolean loop(Context context, CollectionType colType, LoopType lType) {
        boolean stopLoop = false;
        if (lType != null) {
            switch (lType) {
                case FOR: {
                    stopLoop = this.doFor(context);
                    break;
                }
                case WHILE: {
                    stopLoop = this.doWhile(context);
                    break;
                }
                case COLLECTION: {
                    Object collect = context.getParam(this.collectionName);
                    if (collect == null) {
                        logger.error("The set iterated by the loop component does not exist. Please check if the input parameter {} exists", (Object)this.collectionName);
                        throw Error.CONTEXT_NO_PARAMS.expcetion();
                    }
                    stopLoop = this.iterateCollection(collect, context, colType);
                }
            }
        }
        return stopLoop;
    }

    private boolean iterateCollection(Object collect, Context context, CollectionType colType) {
        switch (colType) {
            case LIST: 
            case SET: {
                return this.iterateListSet(collect, context);
            }
            case MAP: {
                return this.iterateMap(collect, context);
            }
            case ARRAY: {
                return this.iterateArray(collect, context);
            }
        }
        return true;
    }

    private boolean iterateArray(Object collect, Context context) {
        Object[] array = (Object[])collect;
        if (this.incrIndex(array.length, context)) {
            return true;
        }
        LoopVariable loopVariable = this.getLoopVariable(context);
        int index = loopVariable.getIndex();
        loopVariable.setElement(array[index]);
        return false;
    }

    private boolean iterateListSet(Object collect, Context context) {
        Collection collection = (Collection)collect;
        if (this.incrIndex(collection.size(), context)) {
            return true;
        }
        LoopVariable loopVariable = this.getLoopVariable(context);
        Iterator iterator = loopVariable.getIterator();
        if (iterator == null) {
            iterator = collection.iterator();
            loopVariable.setIterator(iterator);
        }
        if (!iterator.hasNext()) {
            return true;
        }
        Object value = iterator.next();
        loopVariable.setElement(value);
        return false;
    }

    private boolean iterateMap(Object collect, Context context) {
        Map map = (Map)collect;
        if (this.incrIndex(map.size(), context)) {
            return true;
        }
        LoopVariable loopVariable = this.getLoopVariable(context);
        Iterator iterator = loopVariable.getIterator();
        if (iterator == null) {
            iterator = map.entrySet().iterator();
            loopVariable.setIterator(iterator);
        }
        loopVariable.setIterator(iterator);
        if (!iterator.hasNext()) {
            return true;
        }
        Map.Entry entry = iterator.next();
        loopVariable.setKey(entry.getKey().toString());
        loopVariable.setElement(entry.getValue());
        return false;
    }

    public String getStopCondition() {
        return this.stopCondition;
    }

    public void setStopCondition(String stopCondition) {
        this.stopCondition = stopCondition;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public String getDelta() {
        return this.delta;
    }

    public void setDelta(String delta) {
        this.delta = delta;
        this.deltaInt = Integer.parseInt(delta);
    }

    public String getIndexInit() {
        return this.indexInit;
    }

    public void setIndexInit(String indexInit) {
        this.indexInit = indexInit;
        this.indexInitInt = Integer.parseInt(indexInit);
    }

    public String getLoopType() {
        return this.loopType;
    }

    public void setLoopType(String loopType) {
        this.loopType = loopType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

