/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action.abst;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.AssignType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.OpathUtil;
import cn.com.yusys.yusp.commons.fee.core.component.action.abst.BaseAction;
import cn.com.yusys.yusp.commons.fee.core.component.param.ParamConverFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BizAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(BizAction.class);
    protected String callClassName;
    protected String callMethod;

    protected Object callInvoke(Context context, String actionNodeType) throws Exception {
        if (this.callMethod == null) {
            return null;
        }
        Object[] paramObjects = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Methods[{}.{}], request start", (Object)this.callClassName, (Object)this.callMethod);
        }
        try {
            Class[] paramClasses = null;
            if (this.input != null && this.input.size() > 0) {
                int paramLen = this.input.size();
                paramClasses = new Class[paramLen];
                paramObjects = new Object[paramLen];
                for (int i = 0; i < paramLen; ++i) {
                    Param paramTmp = (Param)this.input.get(i);
                    paramClasses[i] = ClassUtil.strToClass2((String)paramTmp.getClassName(), (boolean)paramTmp.isArray());
                    paramObjects[i] = ActionNodeType.COMMUNICAT.getValue().equals(actionNodeType) ? (!paramTmp.getAssignType().equals(AssignType.CONSTANT.getValue()) ? this.conver(paramTmp, context, this.callMethod) : ParamConverFactory.getParamConver(paramTmp).conver(paramTmp, context)) : ParamConverFactory.getParamConver(paramTmp).conver(paramTmp, context);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Parameter order[{}], type[{}], value[{}]", new Object[]{i, paramTmp.getClassName(), paramObjects[i]});
                }
            }
            Method method = null;
            Class<?> callClassType = ClassUtil.strToClass((String)this.callClassName);
            if (ObjectUtils.isEmpty((Object)callClassType)) {
                if (!StringUtils.isEmpty((Object)this.getCallerContextKey())) {
                    Object param = context.getParam(this.getCallerContextKey());
                    callClassType = param.getClass();
                }
            } else {
                method = callClassType.getMethod(this.callMethod, paramClasses);
            }
            Object callObject = null;
            if (!ObjectUtils.isEmpty((Object)method) && !Modifier.isStatic(method.getModifiers())) {
                callObject = ClassUtil.getCallObject(callClassType);
            }
            Object response = null;
            String contextKey = this.getCallerContextKey();
            if (!StringUtils.isEmpty((Object)contextKey)) {
                Object param = context.getParam(contextKey);
                response = method.invoke(param, paramObjects);
            } else {
                response = method.invoke(callObject, paramObjects);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Method[{}.{}], response result[{}]", new Object[]{this.callClassName, this.callMethod, response});
            }
            if (this.output != null && this.output.isArray()) {
                Class outClassType = ClassUtil.strToClass((String)this.output.getClassName());
                return ClassUtil.objectToArray((Class)outClassType, (Object)response);
            }
            return response;
        }
        catch (ClassNotFoundException e) {
            logger.error("Class information '{}' not found {}", (Object)this.callClassName, (Object)e);
            throw Error.INVOKE_CALL_CLASSNOTFOUND.expcetion();
        }
        catch (NoSuchMethodException e) {
            logger.error("Method '{}' not found {}", (Object)this.callMethod, (Object)e);
            throw Error.INVOKE_CALL_NOSUCHMETHOD.expcetion();
        }
        catch (IllegalAccessException e) {
            logger.error("Method '{}' has no access {}", (Object)this.callMethod, (Object)e);
            throw Error.INVOKE_CALL_ILLEGALACCESS.expcetion();
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid parameter number '{}' {}", paramObjects, (Object)e);
            throw Error.INVOKE_CALL_ILLEGALARGUMENT.expcetion();
        }
        catch (InvocationTargetException e) {
            logger.error("Method reflection failed, the reflected method threw an exception", (Throwable)e);
            throw e;
        }
    }

    private Object conver(Param param, Context context, String methodType) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}={}, type: {}, conversion start", new Object[]{param.getName(), param.getValue(), param.getAssignType()});
        }
        try {
            Object object = OpathUtil.getObject((Context)context, (String)param.getValue());
            if (ClassUtil.isBaseTypebyObject((Object)context.getParam(param.getValue()))) {
                if (methodType.contains("Post")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(param.getValue(), object);
                    return map;
                }
                if (methodType.contains("Get")) {
                    return param.getValue() + "=" + object;
                }
            }
            if (OpathUtil.isOpath((String)param.getName())) {
                OpathUtil.updateObject((String)param.getName(), (Context)context, (Object)object, (String)param.getClassName());
            }
            return object;
        }
        catch (Exception ex) {
            logger.error("Data conversion exception, {}, {}", (Object)param.getValue(), (Object)ex.getMessage());
            throw Error.ASSIGN_TYPE_INVALID.expcetion(ex.getMessage());
        }
    }

    public String getCallClassName() {
        return this.callClassName;
    }

    public void setCallClassName(String callClassName) {
        this.callClassName = callClassName;
    }

    public String getCallMethod() {
        return this.callMethod;
    }

    public void setCallMethod(String callMethod) {
        this.callMethod = callMethod;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public void setAsync(boolean async) {
        this.async = async;
    }
}

