/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action.abst;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.component.Transition;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.component.transition.TransitionFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAction
implements Action {
    private static final Logger logger = LoggerFactory.getLogger(BaseAction.class);
    @Autowired
    protected ComponentFactory factory;
    protected String id;
    protected String nodeType;
    protected List<Param> input;
    protected Param output;
    protected List<Transition> transitions = new ArrayList<Transition>();
    protected String transaction;
    protected boolean async = false;
    protected boolean throwException = true;
    protected boolean printedContext = false;
    private String description;
    private String callerContextKey;
    private String responseConvertClassName;

    public String getCallerContextKey() {
        return this.callerContextKey;
    }

    public void setCallerContextKey(String callerContextKey) {
        this.callerContextKey = callerContextKey;
    }

    public Object execute(Context context) throws Exception {
        return null;
    }

    protected Action getInnerAction(Context context) {
        Map actionMap = this.factory.getFlow((String)context.getProperty("_flowId")).getActionMap();
        List<Transition> transitions = this.getTransitions();
        Action action = null;
        if (transitions == null || transitions.isEmpty()) {
            logger.warn("There is no transfer line for the current component");
        } else {
            Transition transition = TransitionFactory.chooseInner(transitions, context);
            if (transition == null) {
                logger.warn("The current component has no internal connection!");
            } else {
                action = (Action)actionMap.get(transition.getTo());
            }
        }
        return action;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public List<Param> getInput() {
        return this.input;
    }

    public void setInput(List<Param> input) {
        this.input = input;
    }

    public Param getOutput() {
        return this.output;
    }

    public void setOutput(Param output) {
        this.output = output;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<Transition> transitions) {
        transitions.sort(Comparator.comparingInt(o -> Integer.valueOf(o.getOrder())));
        this.transitions = transitions;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isStart() {
        return false;
    }

    public boolean isCloseable() {
        return false;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public String getResponseConvertClassName() {
        return this.responseConvertClassName;
    }

    public void setResponseConvertClassName(String responseConvertClassName) {
        this.responseConvertClassName = responseConvertClassName;
    }

    public boolean isPrintedContext() {
        return this.printedContext;
    }

    public void setPrintedContext(boolean printedContext) {
        this.printedContext = printedContext;
    }
}

