/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.api.rest;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ParamDefinition;
import cn.com.yusys.yusp.commons.fee.core.util.BeanUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class ParamConvert {
    private static final Logger logger = LoggerFactory.getLogger(ParamConvert.class);

    public static void convert(Object params, List<Definition> input, HttpMethod httpMethod) {
        if (params == null) {
            return;
        }
        switch (httpMethod) {
            case GET: {
                ParamConvert.getConvert((Map)params, input);
                break;
            }
            case POST: {
                ParamConvert.postConvert((ObjectNode)params, input);
            }
        }
    }

    public static void postConvert(ObjectNode params, List<Definition> input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        Context rootContext = ContextHolder.getContext();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (Definition d : input) {
            ParamDefinition p = (ParamDefinition)d;
            String key = p.getName();
            String className = p.getClassName();
            Object bean = null;
            if (!params.has(key)) {
                if (input.size() != 1) continue;
                if (ClassUtil.isBasicType((StringBuilder)new StringBuilder(className))) {
                    return;
                }
                try {
                    bean = mapper.treeToValue((TreeNode)params, ClassUtil.strToClass((String)className, (boolean)p.isArray()));
                    rootContext.putParam(key, bean);
                    continue;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw Error.PARAM_CONVERT_ERROR.expcetion(e.getMessage());
                }
            }
            JsonNode value = params.get(key);
            try {
                if (!value.isArray() && !value.isObject()) {
                    bean = BeanUtil.strToBean(className, value.asText());
                }
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
            try {
                if (bean == null) {
                    bean = mapper.treeToValue((TreeNode)value, ClassUtil.strToClass((String)className, (boolean)p.isArray()));
                }
                rootContext.putParam(key, bean);
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
    }

    public static void getConvert(Map<String, Object> params, List<Definition> input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        Context rootContext = ContextHolder.getContext();
        if (input.size() == 1) {
            ParamDefinition p = (ParamDefinition)input.get(0);
            String key = p.getName();
            String className = p.getClassName();
            Object bean = null;
            Object value = params.get(key);
            try {
                if (value != null) {
                    bean = BeanUtil.strToBean(className, value.toString());
                }
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
            if (bean == null) {
                bean = BeanUtil.mapToBean3(params, className);
            }
            if (bean != null) {
                rootContext.putParam(key, bean);
            }
        } else {
            for (Definition d : input) {
                ParamDefinition p = (ParamDefinition)d;
                String key = p.getName();
                String className = p.getClassName();
                Object value = params.get(key);
                try {
                    if (value == null) continue;
                    Object bean = BeanUtil.strToBean(className, value.toString());
                    rootContext.putParam(key, bean);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
    }
}

