/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.api;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.logic.DistributeLock;
import cn.com.yusys.yusp.commons.fee.common.operation.RedisOperations;
import cn.com.yusys.yusp.commons.fee.common.util.ContextUtil;
import cn.com.yusys.yusp.commons.fee.common.util.OpathUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.api.FeeResultDto;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.fee.core.config.IdempotentProperties;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class IdempotentProcessor {
    private static final String IDEMPOTENT_ING = "idempotent-ing";
    public static AtomicBoolean init = new AtomicBoolean(false);
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired(required=false)
    private DistributeLock distributeLock;
    @Autowired(required=false)
    private RedisOperations redisOperations;

    public FeeResultDto startIdempotent(FlowDefinition flowDefinition, String iptKey) {
        IdempotentProperties idempotentProperties = this.applicationProperties.getIdempotent();
        if (idempotentProperties.isEnabled() && flowDefinition.isIdempotent() && !this.isEmpty(iptKey)) {
            this.init();
            String iptRepeatField = StringUtils.isEmpty((Object)flowDefinition.getIptRepeatField()) ? idempotentProperties.getRepeatField() : flowDefinition.getIptRepeatField();
            String redisKey = this.getRedisKey(iptKey);
            boolean repeat = false;
            Object iptRepeatValue = OpathUtil.getObjectBySpel((String)this.processField(iptRepeatField), (Context)ContextUtil.getContext());
            if ("repeat".equals(iptRepeatValue)) {
                repeat = true;
            }
            if (repeat) {
                if (this.distributeLock != null && !this.distributeLock.delIfNotEqual(redisKey, IDEMPOTENT_ING)) {
                    throw Error.ING.expcetion();
                }
            } else {
                FeeResultDto feeResultDto;
                Object lastValue = this.redisOperations.get(redisKey);
                if (lastValue instanceof FeeResultDto && "0".equals((feeResultDto = (FeeResultDto)lastValue).getCode())) {
                    return feeResultDto;
                }
                if (IDEMPOTENT_ING.equals(lastValue)) {
                    throw Error.ING.expcetion();
                }
            }
            if (this.distributeLock != null && !this.distributeLock.lock(redisKey, IDEMPOTENT_ING, 600L)) {
                throw Error.ING.expcetion();
            }
        }
        return null;
    }

    public void processIdempotent(FlowDefinition flowDefinition, FeeResultDto feeResultDto, String iptKey) {
        IdempotentProperties idempotentProperties = this.applicationProperties.getIdempotent();
        if (idempotentProperties.isEnabled() && flowDefinition.isIdempotent() && !this.isEmpty(iptKey)) {
            String iptTtl = StringUtils.isEmpty((Object)flowDefinition.getIptTtl()) ? idempotentProperties.getTtl() : flowDefinition.getIptTtl();
            long ttl = this.parseTtl(iptTtl);
            if (feeResultDto != null && "0".equals(feeResultDto.getCode()) && this.redisOperations != null) {
                this.redisOperations.set(this.getRedisKey(iptKey), (Object)feeResultDto, ttl);
            }
        }
    }

    public void clearIdempotent(FlowDefinition flowDefinition, FeeResultDto feeResultDto, String iptKey) {
        IdempotentProperties idempotentProperties = this.applicationProperties.getIdempotent();
        if (idempotentProperties.isEnabled() && flowDefinition.isIdempotent() && !this.isEmpty(iptKey) && (feeResultDto == null || !"0".equals(feeResultDto.getCode())) && this.distributeLock != null) {
            this.distributeLock.releaseLock(this.getRedisKey(iptKey), IDEMPOTENT_ING);
        }
    }

    public String getIptKey(FlowDefinition flowDefinition) {
        IdempotentProperties idempotentProperties = this.applicationProperties.getIdempotent();
        if (idempotentProperties.isEnabled() && flowDefinition.isIdempotent()) {
            String iptField = StringUtils.isEmpty((Object)flowDefinition.getIptField()) ? idempotentProperties.getKeyField() : flowDefinition.getIptField();
            Object value = OpathUtil.getObjectBySpel((String)this.processField(iptField), (Context)ContextUtil.getContext());
            if (this.isEmpty(value)) {
                throw Error.IDEMPOTENT_ERROR.expcetion("Context missing idempotent field value");
            }
            return value.toString();
        }
        return null;
    }

    private boolean isEmpty(Object object) {
        return object == null || "".equals(object.toString().trim());
    }

    private String processField(String field) {
        if (field.startsWith("[")) {
            return field;
        }
        return "[" + field + "]";
    }

    private long parseTtl(String ttl) {
        if ("0".equals(ttl)) {
            return 0L;
        }
        if (!StringUtils.isEmpty((Object)ttl)) {
            String[] ttlTime = ttl.split(",");
            long ttlValue = 0L;
            for (String pt : ttlTime) {
                String ttlValueStr = pt.substring(0, pt.length() - 1);
                ttlValue = Long.parseLong(ttlValueStr);
                if (pt.endsWith("d")) {
                    ttlValue = ttlValue * 24L * 60L * 60L;
                    continue;
                }
                if (pt.endsWith("H")) {
                    ttlValue = ttlValue * 60L * 60L;
                    continue;
                }
                if (pt.endsWith("m")) {
                    ttlValue *= 60L;
                    continue;
                }
                if (pt.endsWith("s")) continue;
                throw Error.IDEMPOTENT_ERROR.expcetion("Wrong idempotent time effective format");
            }
            return ttlValue;
        }
        throw Error.IDEMPOTENT_ERROR.expcetion("Empty idempotent time effective format");
    }

    private String getRedisKey(String iptKey) {
        return this.applicationProperties.getAppName() + ContextHolder.getContext().getProperty("_flowUrl").toString().replace("/", ".") + "." + iptKey;
    }

    private void init() {
        if (this.distributeLock == null && this.redisOperations == null && init.compareAndSet(false, true)) {
            this.distributeLock = (DistributeLock)SpringContextHolder.getBeanIfExist(DistributeLock.class);
            this.redisOperations = (RedisOperations)SpringContextHolder.getBeanIfExist(RedisOperations.class);
        }
        if (this.distributeLock == null) {
            throw Error.NO_REQUIRED_BEAN.expcetion(DistributeLock.class.getName());
        }
        if (this.redisOperations == null) {
            throw Error.NO_REQUIRED_BEAN.expcetion(RedisOperations.class.getName());
        }
    }
}

