/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.util;

import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;

public class RSAUtil {
    public static Map<String, String> generateKey() {
        ConcurrentHashMap<String, String> rsaKey = new ConcurrentHashMap<String, String>();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            SecureRandom sr = new SecureRandom();
            keyPairGenerator.initialize(512, sr);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            String publicKey = Base64.encodeBase64String((byte[])rsaPublicKey.getEncoded());
            String privateKey = Base64.encodeBase64String((byte[])rsaPrivateKey.getEncoded());
            rsaKey.put(publicKey, privateKey);
            return rsaKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw Error.RSA_PUBLICKEY_ERROR.expcetion(e.getMessage());
        }
    }

    public static String encryptByprivateKey(String content, String privateKeyStr, int opmode) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyStr));
        String text = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(opmode, privateKey);
            if (opmode == 1) {
                byte[] result = cipher.doFinal(content.getBytes());
                text = Base64.encodeBase64String((byte[])result);
            } else if (opmode == 2) {
                byte[] result = cipher.doFinal(Base64.decodeBase64((String)content));
                text = new String(result, "UTF-8");
            }
        }
        catch (Exception e) {
            throw Error.RSA_PRIVATEKEY_ERROR.expcetion(e.getMessage());
        }
        return text;
    }

    public static String encryptByPublicKey(String content, String publicKeyStr, int opmode) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
        String text = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(opmode, publicKey);
            if (opmode == 1) {
                byte[] result = cipher.doFinal(content.getBytes());
                text = Base64.encodeBase64String((byte[])result);
            } else if (opmode == 2) {
                byte[] result = cipher.doFinal(Base64.decodeBase64((String)content));
                text = new String(result, "UTF-8");
            }
        }
        catch (Exception e) {
            throw Error.RSA_PUBLICKEY_ERROR.expcetion(e.getMessage());
        }
        return text;
    }
}

