/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.ThreadLocalClean;
import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Transition;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentCloseAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentStartAction;
import cn.com.yusys.yusp.commons.fee.core.process.AbstractActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.AsyncConcurrentActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ConcurrentActionProcess
extends AbstractActionProcess
implements ThreadLocalClean {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentActionProcess.class);
    private static ThreadLocal<HashMap<String, ConcurrentCloseAction>> concurrentCloseMap = ThreadLocal.withInitial(HashMap::new);
    @Autowired
    AsyncConcurrentActionProcess asyncConcurrentActionProcess;

    @Override
    public void process(Action action, Context context) throws Exception {
        List<Action> nextsList = this.nexts(action, context);
        if (nextsList != null) {
            ActionRunTimeHolder.setThisConcurrentStartAction((ConcurrentStartAction)action);
            for (Action nextAction : nextsList) {
                this.asyncConcurrentActionProcess.process(nextAction, context);
            }
            ActionRunTimeHolder.setConcurrentBeginId(action.getId());
        } else {
            logger.warn("The concurrent transfer list is empty.");
        }
        ConcurrentCloseAction concurrentCloseAction = concurrentCloseMap.get().get(action.getId());
        if (concurrentCloseAction == null) {
            logger.warn("Target transfer selected result is empty.");
            throw Error.ACTION_NEXT_NULL.expcetion();
        }
        this.getActionProcess(concurrentCloseAction).process(concurrentCloseAction, context);
    }

    protected List<Action> nexts(Action action, Context context) throws Exception {
        Map actionMap = this.factory.getFlow((String)context.getProperty("_flowId")).getActionMap();
        List transitions = action.getTransitions();
        if (transitions == null) {
            return null;
        }
        ArrayList<Action> toActionList = new ArrayList<Action>();
        HashMap<String, Action> concurrentStartMap = new HashMap<String, Action>();
        HashMap<String, Action> concurrentEndMap = new HashMap<String, Action>();
        for (Map.Entry entry : actionMap.entrySet()) {
            Action mapAction = (Action)entry.getValue();
            if (mapAction instanceof ConcurrentStartAction) {
                concurrentStartMap.put(mapAction.getId(), mapAction);
            }
            if (!(mapAction instanceof ConcurrentCloseAction)) continue;
            if (!StringUtils.isEmpty(concurrentEndMap.get(((ConcurrentCloseAction)mapAction).getTargetConcurrentStartId()))) {
                throw Error.CONCURRENT_END_HAVE_EXISTED.expcetion();
            }
            concurrentEndMap.put(((ConcurrentCloseAction)mapAction).getTargetConcurrentStartId(), mapAction);
        }
        for (Map.Entry concurrentStartEntry : concurrentStartMap.entrySet()) {
            String concurrentStartActionId = (String)concurrentStartEntry.getKey();
            for (Map.Entry concurrentEndStart : concurrentEndMap.entrySet()) {
                if (!concurrentStartActionId.equals(concurrentEndStart.getKey())) continue;
                concurrentCloseMap.get().put(concurrentStartActionId, (ConcurrentCloseAction)concurrentEndStart.getValue());
            }
        }
        for (Transition transition : transitions) {
            toActionList.add((Action)actionMap.get(transition.getTo()));
        }
        return toActionList;
    }

    @Override
    public ProcessType getProcessType() {
        return ProcessType.CONCURRENT;
    }

    public void clear() throws Exception {
        concurrentCloseMap.remove();
    }
}

