/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.enums.TransactionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.core.executor.ExecutorPool;
import cn.com.yusys.yusp.commons.fee.core.process.AbstractActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AsyncActionProcess
extends AbstractActionProcess {
    private static final Logger logger = LoggerFactory.getLogger(AsyncActionProcess.class);

    @Override
    public void process(Action action, Context context) throws Exception {
        Action next;
        block3: {
            String flowId = (String)context.getProperty("_flowId");
            try {
                Runnable actionRun = () -> {
                    Object status = this.doBegin(action);
                    logger.info("Start asynchronous, component ID: {}", (Object)action.getId());
                    try {
                        MdcParamUtil.initParam((String)"_flowId", (String)flowId);
                        action.execute(context);
                        this.commit(action, status);
                    }
                    catch (Throwable e) {
                        logger.error("Asynchronous component execution exception", e);
                        this.rollback(action, status);
                    }
                    finally {
                        logger.info("End asynchronous, component ID: {}", (Object)action.getId());
                        MdcParamUtil.cleanParam((String)"_flowId");
                        ActionRunTimeHolder.removeAll();
                    }
                };
                ExecutorPool.execute(flowId, actionRun);
                next = this.next(action, context, null);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                next = this.next(action, context, e);
                if (next != null || !action.isThrowException()) break block3;
                throw e;
            }
        }
        if (next == null) {
            throw Error.ACTION_NEXT_NULL.expcetion();
        }
        this.getActionProcess(next).process(next, context);
    }

    @Override
    public void commit(Action currentAction, Object status) {
        if (status == null) {
            return;
        }
        String transactionType = currentAction.getTransaction();
        if (!StringUtils.isEmpty((Object)transactionType)) {
            if (this.feeTransactionManager == null) {
                throw Error.FLOW_TOOL_IS_NOT.expcetion();
            }
            if (transactionType.equals(TransactionType.NEW.getValue())) {
                this.feeTransactionManager.commit(status);
                logger.info("Transaction commit, transaction type: independent, component ID: {}", (Object)currentAction.getId());
            } else {
                logger.warn("Transaction commit, transaction type: global, asynchronous component does not support global transaction, component ID: {}", (Object)currentAction.getId());
            }
        }
    }

    @Override
    public void rollback(Action currentAction, Object status) {
        if (status == null) {
            return;
        }
        String transactionType = currentAction.getTransaction();
        if (!StringUtils.isEmpty((Object)transactionType)) {
            if (this.feeTransactionManager == null) {
                throw Error.FLOW_TOOL_IS_NOT.expcetion();
            }
            if (transactionType.equals(TransactionType.NEW.getValue())) {
                this.feeTransactionManager.rollback(status);
                logger.info("Transaction rollback, transaction type: independent, component ID: {}", (Object)currentAction.getId());
            } else {
                logger.warn("Transaction rollback, transaction type: global, asynchronous component does not support global transaction, component ID: {}", (Object)currentAction.getId());
            }
        }
    }

    @Override
    public ProcessType getProcessType() {
        return ProcessType.CONCURRENTASYNC;
    }
}

