/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.enums.OperationType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.OpathUtil;
import cn.com.yusys.yusp.commons.fee.core.component.action.AssignAction;
import cn.com.yusys.yusp.commons.fee.core.component.param.ParamConverFactory;
import cn.com.yusys.yusp.commons.fee.core.process.AssignActionProcess;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AssignActionObjectProcess
implements AssignActionProcess {
    private static final Logger logger = LoggerFactory.getLogger(AssignActionObjectProcess.class);

    @Override
    public Object execute(Context context, AssignAction action) throws Exception {
        String value = action.getValue();
        Object objByContext = this.getObjByContext(value, context);
        if (StringUtils.isEmpty((Object)objByContext)) {
            return this.newObject(action.getNewObjClassName(), action.getInput(), context);
        }
        if (OperationType.APPEND.getValue().equals(action.getOperationType())) {
            return this.append(objByContext, action.getInput(), context);
        }
        return this.newObject(action.getNewObjClassName(), action.getInput(), context);
    }

    private Object append(Object objByContext, List<Param> params, Context context) throws Exception {
        Object o = this.updateCollection(objByContext, params, context);
        if (!ObjectUtils.isEmpty((Object)o)) {
            return o;
        }
        Class<?> clazz = objByContext.getClass();
        this.setFieldValue(objByContext, params, context, clazz);
        return objByContext;
    }

    private void setFieldValue(Object objByContext, List<Param> params, Context context, Class clazz) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Param currentParam = params.stream().filter(param -> param.getName().equals(name)).findFirst().orElse(null);
            Object contextValue = null;
            if (ObjectUtils.isEmpty((Object)currentParam)) continue;
            contextValue = ParamConverFactory.getParamConver(currentParam).conver(currentParam, context);
            try {
                PropertyDescriptor pd = new PropertyDescriptor(name, clazz);
                Method wM = pd.getWriteMethod();
                wM.invoke(objByContext, contextValue);
            }
            catch (IntrospectionException e) {
                logger.error("FieldName {} is error ", (Object)name);
                throw e;
            }
            catch (IllegalAccessException e) {
                logger.error("Method has no access.", (Throwable)e);
                throw Error.INVOKE_CALL_ILLEGALACCESS.expcetion();
            }
            catch (InvocationTargetException e) {
                logger.error("Method reflection failed, the reflected method threw an exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("FieldName '{}' is error ", (Object)name);
                throw e;
            }
        }
    }

    private Object updateCollection(Object objByContext, List<Param> params, Context context) {
        boolean anInterface = objByContext.getClass().isInterface();
        if (anInterface) {
            throw Error.CLASS_IS_INTERFACE.expcetion();
        }
        if (objByContext instanceof Set) {
            params.forEach(param -> {
                try {
                    Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                    ((HashSet)objByContext).add(paramValue);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            });
            return objByContext;
        }
        if (objByContext instanceof List) {
            params.forEach(param -> {
                try {
                    Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                    ((ArrayList)objByContext).add(paramValue);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            });
            return objByContext;
        }
        if (objByContext instanceof Map) {
            params.forEach(param -> {
                try {
                    Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                    ((Map)objByContext).put(param.getName(), paramValue);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            });
            return objByContext;
        }
        return null;
    }

    private Object getObjByContext(String value, Context context) throws Exception {
        if (StringUtils.isEmpty((Object)value)) {
            throw Error.ACTION_NO_LEFT_PARAM.expcetion();
        }
        if (!value.startsWith("@") && !value.startsWith("[")) {
            value = "[" + value + "]";
        }
        return OpathUtil.getObjectBySpel((String)value, (Context)context);
    }

    private Object newObject(String className, List<Param> params, Context context) throws Exception {
        if (StringUtils.isEmpty((Object)className)) {
            throw Error.ACTION_LACK_ATTRIBUTE.expcetion("Missing class name for the new object");
        }
        Object newObj = ClassUtil.newBaseTypeObject((String)className);
        if (newObj != null) {
            return newObj;
        }
        Class<Object> clazz = Class.forName(className);
        Cloneable obj = null;
        if (clazz.isAssignableFrom(List.class)) {
            obj = new ArrayList();
            for (Param param : params) {
                Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                ((ArrayList)obj).add(paramValue);
            }
            return obj;
        }
        if (clazz.isAssignableFrom(Set.class)) {
            obj = new HashSet();
            for (Param param : params) {
                Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                ((HashSet)obj).add(paramValue);
            }
            return obj;
        }
        if (clazz.isAssignableFrom(Map.class)) {
            obj = new HashMap();
            for (Param param : params) {
                Object paramValue = ParamConverFactory.getParamConver(param).conver(param, context);
                ((HashMap)obj).put(param.getName(), paramValue);
            }
            return obj;
        }
        boolean anInterface = clazz.isInterface();
        if (anInterface) {
            throw Error.CLASS_IS_INTERFACE.expcetion();
        }
        obj = clazz.newInstance();
        this.setFieldValue(obj, params, context, clazz);
        return obj;
    }
}

