/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.process;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.component.Transition;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.TransactionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.operation.TransactionOperations;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.component.action.ErrorProxyAction;
import cn.com.yusys.yusp.commons.fee.core.component.transition.TransitionFactory;
import cn.com.yusys.yusp.commons.fee.core.process.ActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import cn.com.yusys.yusp.commons.fee.core.process.ErrorProxyActionProcess;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractActionProcess
implements ActionProcess {
    private static final Logger logger = LoggerFactory.getLogger(AbstractActionProcess.class);
    @Autowired(required=false)
    protected TransactionOperations feeTransactionManager;
    @Autowired
    protected ComponentFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(Action action, Context context) throws Exception {
        long startTime;
        block8: {
            MdcParamUtil.initParam((String)"_actionId", (String)action.getId());
            startTime = System.currentTimeMillis();
            try {
                Object response = action.execute(context);
                if (response == null) break block8;
                this.putResponseToContext(action, context, response);
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                logger.info("    [{}].{} execute time: [{} ms]", new Object[]{action.getId(), action.getDescription(), endTime - startTime});
                if (!ObjectUtils.isEmpty((Object)context.getProperty("logs"))) {
                    ((List)context.getProperty("logs")).add("               [" + action.getId() + "]." + action.getDescription() + " execute time: [" + (endTime - startTime) + " ms]");
                }
                if (action.isPrintedContext()) {
                    logger.info("    Action:{} start printing context information ", (Object)action.getId());
                    Map paramMap = context.getParamMap();
                    for (Map.Entry entry : paramMap.entrySet()) {
                        logger.info("    context key:{},value:{}", entry.getKey(), entry.getValue());
                    }
                    logger.info("    Action:{} end printing", (Object)action.getId());
                }
                MdcParamUtil.cleanParam((String)"_actionId");
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("    [{}].{} execute time: [{} ms]", new Object[]{action.getId(), action.getDescription(), endTime - startTime});
        if (!ObjectUtils.isEmpty((Object)context.getProperty("logs"))) {
            ((List)context.getProperty("logs")).add("               [" + action.getId() + "]." + action.getDescription() + " execute time: [" + (endTime - startTime) + " ms]");
        }
        if (action.isPrintedContext()) {
            logger.info("    Action:{} start printing context information ", (Object)action.getId());
            Map paramMap = context.getParamMap();
            for (Map.Entry entry : paramMap.entrySet()) {
                logger.info("    context key:{},value:{}", entry.getKey(), entry.getValue());
            }
            logger.info("    Action:{} end printing", (Object)action.getId());
        }
        MdcParamUtil.cleanParam((String)"_actionId");
    }

    private void putResponseToContext(Action action, Context context, Object object) {
        Param output = action.getOutput();
        if (output != null && !StringUtils.isEmpty((Object)output.getValue())) {
            context.putParam(output.getValue(), object);
        }
    }

    protected ActionProcess getActionProcess(Action action) {
        ActionProcess actionProcess = ProcessFactory.getProcess(action);
        if (action instanceof ErrorProxyAction) {
            ErrorProxyActionProcess proxyActionProcess = new ErrorProxyActionProcess(actionProcess);
            SpringContextHolder.getApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)proxyActionProcess);
            return proxyActionProcess;
        }
        return actionProcess;
    }

    protected Action next(Action action, Context context, Throwable able) {
        Map actionMap = this.factory.getFlow((String)context.getProperty("_flowId")).getActionMap();
        List transitions = action.getTransitions();
        if (transitions == null) {
            return null;
        }
        Transition transition = able != null ? TransitionFactory.chooseExcep(transitions, context, able) : TransitionFactory.chooseNormal(transitions, context);
        if (transition == null) {
            return null;
        }
        return (Action)actionMap.get(transition.getTo());
    }

    public Object doBegin(Action currentAction) {
        ActionRunTimeHolder.removePoint();
        if (!ActionNodeType.MAPPER.getValue().equals(currentAction.getNodeType()) && !ActionNodeType.DB.getValue().equals(currentAction.getNodeType())) {
            return null;
        }
        if (StringUtils.isEmpty((Object)currentAction.getTransaction())) {
            return null;
        }
        if (this.feeTransactionManager == null) {
            throw Error.FLOW_TOOL_IS_NOT.expcetion();
        }
        if (TransactionType.NEW.getValue().equals(currentAction.getTransaction())) {
            return this.feeTransactionManager.beginNew();
        }
        if (TransactionType.REQUIRED.getValue().equals(currentAction.getTransaction())) {
            return this.feeTransactionManager.begin();
        }
        return null;
    }

    public void commit(Action currentAction, Object status) {
    }

    public void rollback(Action currentAction, Object status) {
        if (status == null) {
            return;
        }
        String transactionType = currentAction.getTransaction();
        if (!StringUtils.isEmpty((Object)transactionType)) {
            if (this.feeTransactionManager == null) {
                throw Error.FLOW_TOOL_IS_NOT.expcetion();
            }
            if (transactionType.equals(TransactionType.NEW.getValue())) {
                if (!ObjectUtils.isEmpty((Object)this.feeTransactionManager)) {
                    this.feeTransactionManager.rollback(status);
                }
                logger.info("Transaction rollback, transaction type: independent, component ID: {}", (Object)currentAction.getId());
            } else if (transactionType.equals(TransactionType.REQUIRED.getValue())) {
                ActionRunTimeHolder.addTransaction(status);
                logger.info("Transaction rollback, transaction type: global, component ID: {}", (Object)currentAction.getId());
            }
        }
    }

    public void allCommit(HashSet<Object> list) {
        if (this.feeTransactionManager == null) {
            throw Error.FLOW_TOOL_IS_NOT.expcetion();
        }
        this.feeTransactionManager.allCommit(list);
    }

    public void allRollback(HashSet<Object> list) {
        if (this.feeTransactionManager == null) {
            throw Error.FLOW_TOOL_IS_NOT.expcetion();
        }
        this.feeTransactionManager.allRollback(list);
    }
}

