/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.parsexml.loader;

import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.init.XmlLoaderRegister;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.XMLLoader;
import cn.com.yusys.yusp.commons.fee.core.parsexml.model.XMLInfo;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JarLoader
extends XMLLoader {
    private static final Logger logger = LoggerFactory.getLogger(JarLoader.class);
    @Autowired
    private XmlLoaderRegister loaderRegister;

    @Override
    public void doRegistryXML(String path) {
        try {
            Resource[] resources;
            if (!path.startsWith("classpath")) {
                this.doFileModify();
            }
            PathMatchingResourcePatternResolver p = new PathMatchingResourcePatternResolver();
            for (Resource r : resources = p.getResources(path)) {
                this.loadXMLAndRegister(r);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.FLOW_CHK_INVALID.expcetion();
        }
    }

    protected void loadXMLAndRegister(Resource resource) {
        try {
            XMLInfo xmlInfo;
            String xmlPath = null;
            if (this.isJar()) {
                xmlPath = resource.getDescription();
                if (xmlPath.startsWith("file [")) {
                    xmlPath = xmlPath.substring(6, xmlPath.length() - 1);
                }
            } else {
                xmlPath = resource.getFile().getPath();
            }
            if ((xmlInfo = this.loaderRegister.getXmlInfos().get(xmlPath)) == null || xmlInfo.getLoadTime() != resource.lastModified()) {
                this.loaderRegister.registry(xmlInfo, resource);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.FLOW_CHK_INVALID.expcetion();
        }
    }

    @Override
    public void doFileModify() {
        Map<String, XMLInfo> xmlInfos = this.loaderRegister.getXmlInfos();
        for (Map.Entry<String, XMLInfo> entry : xmlInfos.entrySet()) {
            String fileName = entry.getKey();
            XMLInfo xmlInfo = entry.getValue();
            File file = new File(fileName);
            if (file == null || file.exists()) continue;
            logger.info("filename[{}] is not exists......", (Object)fileName);
            this.loaderRegister.invalidationDefinition(xmlInfo.getDefinition().getId());
            this.loaderRegister.getXmlInfos().remove(fileName);
        }
    }
}

