/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.parsexml.loader;

import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.init.XmlLoaderRegister;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.XMLLoader;
import cn.com.yusys.yusp.commons.fee.core.parsexml.model.XMLInfo;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FileLoader
extends XMLLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileLoader.class);
    @Autowired
    private XmlLoaderRegister loaderRegister;

    @Override
    public void doRegistryXML(String path) {
        this.doFileModify();
        this.loadAndRegister(path);
    }

    private void loadAndRegister(String filePath) {
        File[] files;
        File fileclass = new File(filePath);
        if (fileclass != null && (files = fileclass.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!"xml".equals(file.getName().substring(file.getName().lastIndexOf(".") + 1))) continue;
                    String xmlPath = file.getPath();
                    long lastModified = file.lastModified();
                    XMLInfo xmlInfo = this.loaderRegister.getXmlInfos().get(xmlPath);
                    if (xmlInfo != null && xmlInfo.getLoadTime() == lastModified) continue;
                    try {
                        this.loaderRegister.registry(xmlInfo, file);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                        throw Error.FLOW_CHK_INVALID.expcetion();
                    }
                }
                this.loadAndRegister(file.getPath());
            }
        }
    }

    @Override
    public void doFileModify() {
        Map<String, XMLInfo> xmlInfos = this.loaderRegister.getXmlInfos();
        for (Map.Entry<String, XMLInfo> entry : xmlInfos.entrySet()) {
            String fileName = entry.getKey();
            XMLInfo xmlInfo = entry.getValue();
            File file = new File(fileName);
            if (file == null || file.exists()) continue;
            logger.info("filename[{}] is not exists......", (Object)fileName);
            this.loaderRegister.invalidationDefinition(xmlInfo.getDefinition().getId());
            this.loaderRegister.getXmlInfos().remove(fileName);
        }
    }
}

