/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init.parse;

import cn.com.yusys.yusp.commons.fee.common.Parser;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.init.TagDefinitionMapping;
import cn.com.yusys.yusp.commons.fee.core.parsexml.XMLDocumentLoader;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowParser
implements Parser {
    private static final Logger logger = LoggerFactory.getLogger(FlowParser.class);
    private TagDefinitionMapping tagDefinitionMapping = TagDefinitionMapping.getInstance();

    public Definition parse(String xmlFileName) {
        Document document;
        logger.info("=============xlFilename===========");
        XMLDocumentLoader loader = new XMLDocumentLoader();
        try {
            document = loader.loadXMLDocument(xmlFileName);
        }
        catch (Exception e) {
            logger.error("xml import failed, xmlFileName={}", (Object)xmlFileName, (Object)e);
            throw Error.XML_PARSE_ERROR.expcetion();
        }
        logger.info("xml import succeeded, start parsing xml, xmlFileName={}", (Object)xmlFileName);
        return this.parse(document);
    }

    public Definition parse(InputStream stream) {
        Document document;
        XMLDocumentLoader loader = new XMLDocumentLoader();
        try {
            document = loader.loadXMLDocument(stream);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.XML_PARSE_ERROR.expcetion();
        }
        return this.parse(document);
    }

    private Definition parse(Document document) {
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"flow".equalsIgnoreCase(node.getNodeName()) || !this.isEleNode(node)) continue;
            return this.parse(node);
        }
        return null;
    }

    public Definition parse(Node elementNode) {
        if (elementNode == null || !this.isEleNode(elementNode) || !this.tagDefinitionMapping.hasDefinition(elementNode.getNodeName())) {
            return null;
        }
        Class<? extends Definition> definitionClass = this.tagDefinitionMapping.getDefinition(elementNode.getNodeName());
        try {
            Definition definition = definitionClass.newInstance();
            this.setAttribute(elementNode, definition);
            return definition;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
            throw Error.XML_PARSE_ERROR.expcetion();
        }
    }

    public void checkDefinition() {
    }

    private boolean isEleNode(Node node) {
        return node.getNodeType() == 1;
    }

    public void setAttribute(Node elementNode, Definition definition) {
        Map fieldMap = ClassUtil.getFieldType(definition.getClass());
        Map setterMethodMap = ClassUtil.getFieldSetter(definition.getClass());
        NamedNodeMap namedNodeMap = elementNode.getAttributes();
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Node attrNode = namedNodeMap.item(j);
            String attrName = attrNode.getNodeName();
            if ("isArray".equalsIgnoreCase(attrName)) {
                attrName = "array";
            }
            if (!fieldMap.containsKey(attrName)) continue;
            Class fieldType = (Class)fieldMap.get(attrName);
            Method setter = (Method)setterMethodMap.get(attrName);
            try {
                if (String.class == fieldType) {
                    setter.invoke((Object)definition, attrNode.getNodeValue());
                    continue;
                }
                if (Boolean.TYPE != fieldType && Boolean.class != fieldType) continue;
                setter.invoke((Object)definition, attrNode.getNodeValue().equalsIgnoreCase("true"));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("", (Throwable)e);
                throw Error.XML_PARSE_ERROR.expcetion();
            }
        }
        NodeList childNodes = elementNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String childNodeName;
            Node childNode = childNodes.item(i);
            if (!this.isEleNode(childNode) || !fieldMap.containsKey(childNodeName = childNode.getNodeName())) continue;
            Class fieldType = (Class)fieldMap.get(childNodeName);
            Method setter = (Method)setterMethodMap.get(childNodeName);
            this.setSubAttribute(childNode, definition, setter, fieldType);
        }
    }

    private void setSubAttribute(Node childNode, Definition definition, Method setter, Class fieldType) {
        block6: {
            String childNodeName = childNode.getNodeName();
            try {
                if (this.tagDefinitionMapping.hasDefinition(childNodeName)) {
                    setter.invoke((Object)definition, this.parse(childNode));
                    return;
                }
                NodeList grandsonNodes = childNode.getChildNodes();
                if (List.class.isAssignableFrom(fieldType)) {
                    ArrayList<Definition> list = new ArrayList<Definition>();
                    for (int j = 0; j < grandsonNodes.getLength(); ++j) {
                        Node child = grandsonNodes.item(j);
                        if (child.getNodeType() != 1 || !this.tagDefinitionMapping.hasDefinition(child.getNodeName())) continue;
                        list.add(this.parse(child));
                    }
                    setter.invoke((Object)definition, list);
                    break block6;
                }
                if (!Definition.class.isAssignableFrom(fieldType)) break block6;
                for (int j = 0; j < grandsonNodes.getLength(); ++j) {
                    Node child = grandsonNodes.item(j);
                    if (child.getNodeType() != 1 || !this.tagDefinitionMapping.hasDefinition(child.getNodeName())) continue;
                    setter.invoke((Object)definition, this.parse(grandsonNodes.item(j)));
                    break;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("", (Throwable)e);
                throw Error.XML_PARSE_ERROR.expcetion();
            }
        }
    }
}

