/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init.definition;

import cn.com.yusys.yusp.commons.fee.common.annotation.FeeConverter;
import cn.com.yusys.yusp.commons.fee.common.annotation.XmlNode;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.core.init.converter.FlowConverter;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ActionDefinition;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ParamDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

@XmlNode(value="flow")
@FeeConverter(converter=FlowConverter.class)
public class FlowDefinition
implements Definition {
    private String id;
    private String flowId;
    private String description;
    private String url;
    private String requestType = "POST";
    private boolean publish;
    private boolean enableBSP = false;
    private boolean enableREST = true;
    private List<Definition> input;
    private ParamDefinition output;
    private List<Definition> actions;
    private List<Definition> global;
    private Map<String, ActionDefinition> actionMap = new HashMap<String, ActionDefinition>();
    private String intercepterClassName;
    private String intercepterName;
    private String bspIntercepter;
    private boolean idempotent;
    private String iptField;
    private String iptTtl;
    private String iptRepeatField;
    private String serviceCombType = "";
    private String swaggerTags = "default";
    private String swaggerSummary;
    private String swaggerConsumes = "application/json";
    private String swaggerProduces = "application/json";
    private String severalPreHandleClassName;
    private String severalPostHandleClassName;
    private String severalBSPPreHandleClassName;
    private String severalBSPPostHandleClassName;
    private String tradeCode;

    public String getSeveralBSPPreHandleClassName() {
        return this.severalBSPPreHandleClassName;
    }

    public void setSeveralBSPPreHandleClassName(String severalBSPPreHandleClassName) {
        this.severalBSPPreHandleClassName = severalBSPPreHandleClassName;
    }

    public String getSeveralBSPPostHandleClassName() {
        return this.severalBSPPostHandleClassName;
    }

    public void setSeveralBSPPostHandleClassName(String severalBSPPostHandleClassName) {
        this.severalBSPPostHandleClassName = severalBSPPostHandleClassName;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getSeveralPreHandleClassName() {
        return this.severalPreHandleClassName;
    }

    public void setSeveralPreHandleClassName(String severalPreHandleClassName) {
        this.severalPreHandleClassName = severalPreHandleClassName;
    }

    public String getSeveralPostHandleClassName() {
        return this.severalPostHandleClassName;
    }

    public void setSeveralPostHandleClassName(String severalPostHandleClassName) {
        this.severalPostHandleClassName = severalPostHandleClassName;
    }

    public String getIntercepterName() {
        return this.intercepterName;
    }

    public void setIntercepterName(String intercepterName) {
        this.intercepterName = intercepterName;
    }

    public String getIntercepterClassName() {
        return this.intercepterClassName;
    }

    public void setIntercepterClassName(String intercepterClassName) {
        this.intercepterClassName = intercepterClassName;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public void setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
    }

    public String getIptField() {
        return this.iptField;
    }

    public void setIptField(String iptField) {
        this.iptField = iptField;
    }

    public String getIptTtl() {
        return this.iptTtl;
    }

    public void setIptTtl(String iptTtl) {
        this.iptTtl = iptTtl;
    }

    public String getIptRepeatField() {
        return this.iptRepeatField;
    }

    public void setIptRepeatField(String iptRepeatField) {
        this.iptRepeatField = iptRepeatField;
    }

    public String getServiceCombType() {
        return this.serviceCombType;
    }

    public void setServiceCombType(String serviceCombType) {
        this.serviceCombType = serviceCombType;
    }

    public boolean isEnableBSP() {
        return this.enableBSP;
    }

    public boolean isEnableREST() {
        return this.enableREST;
    }

    public void setEnableREST(boolean enableREST) {
        this.enableREST = enableREST;
    }

    public void setEnableBSP(boolean enableBSP) {
        this.enableBSP = enableBSP;
    }

    public String getSwaggerTags() {
        return this.swaggerTags;
    }

    public void setSwaggerTags(String swaggerTags) {
        this.swaggerTags = swaggerTags;
    }

    public String getSwaggerSummary() {
        return this.swaggerSummary;
    }

    public void setSwaggerSummary(String swaggerSummary) {
        this.swaggerSummary = swaggerSummary;
    }

    public String getSwaggerConsumes() {
        return this.swaggerConsumes;
    }

    public void setSwaggerConsumes(String swaggerConsumes) {
        this.swaggerConsumes = swaggerConsumes;
    }

    public String getSwaggerProduces() {
        return this.swaggerProduces;
    }

    public void setSwaggerProduces(String swaggerProduces) {
        this.swaggerProduces = swaggerProduces;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        if (!StringUtils.isEmpty((Object)this.url)) {
            if (!this.url.startsWith("/")) {
                this.url = "/" + this.url;
            }
            if (this.url.endsWith("/")) {
                this.url = this.url.substring(0, this.url.length() - 1);
            }
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public List<Definition> getInput() {
        return this.input;
    }

    public void setInput(List<Definition> input) {
        this.input = input;
    }

    public Definition getOutput() {
        return this.output;
    }

    public void setOutput(ParamDefinition output) {
        this.output = output;
    }

    public List<Definition> getActions() {
        return this.actions;
    }

    public void setActions(List<Definition> actions) {
        this.actions = actions;
        if (!actions.isEmpty()) {
            actions.forEach(e -> {
                ActionDefinition actionDefinition = (ActionDefinition)e;
                this.actionMap.put(actionDefinition.getId(), actionDefinition);
            });
        }
    }

    public void addAction(ActionDefinition actionDefinition) {
        this.actions.add(actionDefinition);
        this.actionMap.put(actionDefinition.getId(), actionDefinition);
    }

    public ActionDefinition getAction(String actionId) {
        return this.actionMap.get(actionId);
    }

    public List<Definition> getGlobal() {
        return this.global;
    }

    public void setGlobal(List<Definition> global) {
        this.global = global;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.id = flowId;
        this.flowId = flowId;
    }

    public String getBspIntercepter() {
        return this.bspIntercepter;
    }

    public void setBspIntercepter(String bspIntercepter) {
        this.bspIntercepter = bspIntercepter;
    }

    public String toString() {
        return "FlowDefinition{id='" + this.id + '\'' + ", flowId='" + this.flowId + '\'' + ", description='" + this.description + '\'' + ", url='" + this.url + '\'' + ", requestType='" + this.requestType + '\'' + ", publish=" + this.publish + ", enableBSP=" + this.enableBSP + ", enableREST=" + this.enableREST + ", input=" + this.input + ", output=" + this.output + ", actions=" + this.actions + ", global=" + this.global + ", actionMap=" + this.actionMap + ", intercepterName='" + this.intercepterClassName + '\'' + ", bspIntercepter='" + this.bspIntercepter + '\'' + ", swaggerTags='" + this.swaggerTags + '\'' + ", swaggerSummary='" + this.swaggerSummary + '\'' + ", swaggerConsumes='" + this.swaggerConsumes + '\'' + ", serviceCombType='" + this.serviceCombType + '\'' + ", swaggerProduces='" + this.swaggerProduces + '\'' + '}';
    }
}

