/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init.converter;

import cn.com.yusys.yusp.commons.fee.common.component.DefCompConverter;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConverterFactory.class);
    private static Map<String, DefCompConverter> map = new WeakHashMap<String, DefCompConverter>();

    public static DefCompConverter getConverter(Class<? extends DefCompConverter> clazz) {
        String className = clazz.getName();
        if (map.containsKey(className)) {
            return map.get(className);
        }
        try {
            DefCompConverter compConverter = clazz.newInstance();
            map.put(className, compConverter);
            return compConverter;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static DefCompConverter getConverter(String className) {
        if (map.containsKey(className)) {
            return map.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (!DefCompConverter.class.isAssignableFrom(clazz)) {
                return null;
            }
            DefCompConverter compConverter = (DefCompConverter)clazz.newInstance();
            map.put(className, compConverter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }
}

