/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init.converter;

import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.init.converter.AbstractConverter;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ActionDefinition;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ActionConverter
extends AbstractConverter {
    private static final Logger logger = LoggerFactory.getLogger(ActionConverter.class);

    public Object convert(Object object, String flowId) {
        Class<?> clazz = object.getClass();
        if (ActionDefinition.class == clazz) {
            ActionDefinition actionDefinition = (ActionDefinition)object;
            String nodeType = actionDefinition.getNodeType();
            String className = ActionNodeType.getAction((String)nodeType);
            if (StringUtils.isEmpty((Object)className)) {
                logger.error("Component property exception, nodeType={}", (Object)nodeType);
                throw Error.ACTION_TYPE_EXCEPTION.expcetion();
            }
            try {
                Class<?> c = Class.forName(className);
                HashMap<String, Object> actionDefMap = new HashMap<String, Object>();
                this.definition2Map(actionDefinition, actionDefMap, flowId);
                String beanName = "flowBeanId_" + flowId + "." + actionDefMap.get("id");
                this.addSpringBean(c, actionDefMap, beanName);
                return this.applicationContext.containsBean(beanName) ? this.applicationContext.getBean(beanName) : null;
            }
            catch (ClassNotFoundException e) {
                logger.error("", (Throwable)e);
                throw Error.INNER_ERROR.expcetion();
            }
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

