/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init.converter;

import cn.com.yusys.yusp.commons.fee.common.annotation.FeeConverter;
import cn.com.yusys.yusp.commons.fee.common.component.DefCompConverter;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractConverter
implements DefCompConverter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConverter.class);
    protected ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();

    public Object attributeConvert(Object object, String flowId) {
        Class<?> clazz = object.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            if (!list.isEmpty()) {
                ArrayList l = new ArrayList();
                list.forEach(e -> {
                    Object o;
                    if (e instanceof Definition && (o = this.attributeConvert(e, flowId)) != null) {
                        l.add(o);
                    }
                });
                if (!l.isEmpty()) {
                    return l;
                }
            }
        } else if (clazz.isAnnotationPresent(FeeConverter.class)) {
            FeeConverter converter = clazz.getAnnotation(FeeConverter.class);
            Class converterClass = converter.converter();
            try {
                DefCompConverter compConverter = (DefCompConverter)converterClass.newInstance();
                return compConverter.convert(object, flowId);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                logger.error("", (Throwable)e2);
                throw Error.INNER_ERROR.expcetion();
            }
        }
        return null;
    }

    protected void definition2Map(Definition definition, Map<String, Object> defMap, String flowId) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(definition.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = propertyDescriptor.getName();
                Class<?> fieldType = propertyDescriptor.getPropertyType();
                Method getter = propertyDescriptor.getReadMethod();
                Object value = getter.invoke((Object)definition, new Object[0]);
                if (value == null) continue;
                if (String.class == fieldType || Boolean.TYPE == fieldType) {
                    defMap.put(fieldName, value);
                    continue;
                }
                defMap.put(fieldName, this.attributeConvert(value, flowId));
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error("", (Throwable)e);
            throw Error.INNER_ERROR.expcetion();
        }
    }

    protected void addSpringBean(Class clazz, Map<String, Object> map, String beanName) {
        Set fieldNames = ClassUtil.getFieldNames((Class)clazz);
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
        map.forEach((k, v) -> {
            if (fieldNames.contains(k) && v != null) {
                beanDefinitionBuilder.addPropertyValue(k, v);
            }
        });
        defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }
}

