/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init;

import cn.com.yusys.yusp.commons.fee.common.SwaggerHotLoad;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.enums.ControllerMethod;
import cn.com.yusys.yusp.commons.fee.common.enums.XmlFileStatus;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.core.FeeRunner;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.component.flow.StandardFlow;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.fee.core.config.FeeProperties;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.MappingService;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import cn.com.yusys.yusp.commons.fee.core.init.parse.FlowParser;
import cn.com.yusys.yusp.commons.fee.core.parsexml.loader.XMLLoader;
import cn.com.yusys.yusp.commons.fee.core.parsexml.model.XMLInfo;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class XmlLoaderRegister
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private static final Logger logger = LoggerFactory.getLogger(XmlLoaderRegister.class);
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;
    @Autowired
    private MappingService mappingService;
    @Autowired
    private ComponentFactory componentFactory;
    @Autowired(required=false)
    private SwaggerHotLoad hotLoadSwagger;
    @Autowired
    private FeeRunner feeRunner;
    @Autowired
    private ApplicationProperties applicationProperties;
    private FeeProperties feeProperties;
    @Autowired
    private FlowParser flowParser;
    private static Map<String, XMLInfo> xmlInfos = new ConcurrentHashMap<String, XMLInfo>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void doRegistryAndMapping(Definition flowDefinition) {
        this.flowDefinitionRegistry.registry((FlowDefinition)flowDefinition);
        if (((FlowDefinition)flowDefinition).isPublish()) {
            this.setMapping(flowDefinition);
        }
        this.getFlow(flowDefinition);
    }

    protected void setMapping(Definition flowDefinition) {
        this.setRestMapping(flowDefinition);
        this.setHotLoadSwagger(flowDefinition);
        this.setBSPMapping((FlowDefinition)flowDefinition);
    }

    private void setRestMapping(Definition flowDefinition) {
        if (((FlowDefinition)flowDefinition).isEnableREST()) {
            if ("GET".equalsIgnoreCase(((FlowDefinition)flowDefinition).getRequestType())) {
                this.mappingService.addMapping(ControllerMethod.GET_ACCESS, ((FlowDefinition)flowDefinition).getUrl());
            } else if ("POST".equalsIgnoreCase(((FlowDefinition)flowDefinition).getRequestType())) {
                this.mappingService.addMapping(ControllerMethod.POST_ACCESS, ((FlowDefinition)flowDefinition).getUrl());
            }
        } else {
            RequestMappingInfo requestMappingInfo = "POST".equalsIgnoreCase(((FlowDefinition)flowDefinition).getRequestType()) ? RequestMappingInfo.paths((String[])new String[]{((FlowDefinition)flowDefinition).getUrl()}).methods(new RequestMethod[]{RequestMethod.POST}).build() : RequestMappingInfo.paths((String[])new String[]{((FlowDefinition)flowDefinition).getUrl()}).methods(new RequestMethod[]{RequestMethod.GET}).build();
            this.mappingService.removeMapping(requestMappingInfo);
        }
    }

    private void setBSPMapping(FlowDefinition flowDefinition) {
        if (ClassUtils.isPresent((String)"cn.com.yusys.yusp.bsp.app.config.AppStartAssist", null)) {
            if (flowDefinition.isEnableBSP()) {
                FlowUtil.putFlowUrlByBspTradeCode((String)flowDefinition.getUrl(), (String)flowDefinition.getFlowId());
            } else {
                FlowUtil.removeFlowUrlByBspTradeCode((String)flowDefinition.getUrl());
            }
        } else if (flowDefinition.isEnableBSP()) {
            logger.warn("Not import bsp jar!");
        }
    }

    protected void getFlow(Definition flowDefinition) {
        if (this.feeProperties.isPreLoadAllFlows()) {
            this.componentFactory.getFlow(((FlowDefinition)flowDefinition).getFlowId());
        }
    }

    public void invalidationDefinition(String flowId) {
        StandardFlow flowDefinition = (StandardFlow)this.componentFactory.getFlow(flowId);
        if (flowDefinition == null) {
            return;
        }
        this.flowDefinitionRegistry.unRegistry(flowDefinition);
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        flowDefinition.getActions().forEach(action -> {
            String actionBeanName = "flowBeanId_" + flowDefinition.getFlowId() + "." + action.getId();
            if (this.applicationContext.containsBean(actionBeanName)) {
                defaultListableBeanFactory.removeBeanDefinition(actionBeanName);
                logger.info("Clear action bean: {}", (Object)actionBeanName);
            }
        });
        String flowBeanName = "flowBeanId_" + flowDefinition.getFlowId();
        if (this.applicationContext.containsBean(flowBeanName)) {
            defaultListableBeanFactory.removeBeanDefinition(flowBeanName);
            logger.info("Clear flow bean: {}", (Object)flowBeanName);
        }
        RequestMappingInfo requestMappingInfo = flowDefinition.getRequestType().equals("POST") ? RequestMappingInfo.paths((String[])new String[]{flowDefinition.getUrl()}).methods(new RequestMethod[]{RequestMethod.POST}).build() : RequestMappingInfo.paths((String[])new String[]{flowDefinition.getUrl()}).methods(new RequestMethod[]{RequestMethod.GET}).build();
        this.mappingService.removeMapping(requestMappingInfo);
        logger.info("Delete RUL mapping {}", (Object)flowDefinition.getUrl());
        this.setHotLoadSwagger(flowDefinition);
        FlowUtil.removeFlowIds((String)flowDefinition.getFlowId());
    }

    public Map<String, XMLInfo> getXmlInfos() {
        return xmlInfos;
    }

    protected void setHotLoadSwagger(Definition flowDefinition) {
        if (this.hotLoadSwagger != null && this.feeRunner.isStarted()) {
            this.hotLoadSwagger.setNewLoad(true);
            this.hotLoadSwagger.setFlowId(((FlowDefinition)flowDefinition).getFlowId());
        }
    }

    protected void setHotLoadSwagger(Flow flowDefinition) {
        if (this.hotLoadSwagger != null && this.feeRunner.isStarted()) {
            this.hotLoadSwagger.setNewLoad(true);
            this.hotLoadSwagger.setFlowId(flowDefinition.getFlowId());
        }
    }

    public void registry(XMLInfo xmlInfo, File file) throws FeeException {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            Definition flowDefinition = this.flowParser.parse(inputStream);
            String fileName = file.getPath();
            long lastModified = file.lastModified();
            this.registry(flowDefinition, xmlInfo, fileName, lastModified);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.FLOW_CHK_INVALID.expcetion();
        }
    }

    public void registry(XMLInfo xmlInfo, Resource resource) throws FeeException {
        try {
            Definition flowDefinition = this.flowParser.parse(resource.getInputStream());
            String fileName = null;
            long lastModified = resource.lastModified();
            if (this.isJar()) {
                fileName = resource.getDescription();
                if (fileName.startsWith("file [")) {
                    fileName = fileName.substring(6, fileName.length() - 1);
                }
            } else {
                fileName = resource.getFile().getPath();
            }
            this.registry(flowDefinition, xmlInfo, fileName, lastModified);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.FLOW_CHK_INVALID.expcetion();
        }
    }

    public void registry(Definition flowDefinition, XMLInfo xmlInfo, String fileName, long lastModified) throws FeeException {
        try {
            if (flowDefinition != null) {
                logger.info("xml parsing succeeded, fileName={}", (Object)fileName);
                if (xmlInfo == null) {
                    xmlInfo = XMLInfo.builder().definition(flowDefinition).fileName(fileName).fileStatus(XmlFileStatus.IS_USED.getValue()).loadTime(lastModified);
                    FlowUtil.addFlowIds((String)((FlowDefinition)flowDefinition).getFlowId());
                } else {
                    xmlInfo = XMLInfo.builder(xmlInfo).loadTime(lastModified).definition(flowDefinition);
                    this.invalidationDefinition(xmlInfo.getDefinition().getId());
                }
                this.doRegistryAndMapping(flowDefinition);
                xmlInfos.put(fileName, xmlInfo);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.FLOW_CHK_INVALID.expcetion();
        }
    }

    protected boolean isJar() {
        URL url = XMLLoader.class.getResource("");
        String protocol = url.getProtocol();
        return "jar".equals(protocol);
    }

    public void afterPropertiesSet() throws Exception {
        this.feeProperties = this.applicationProperties.getFee();
    }
}

