/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.init;

import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.core.component.flow.StandardFlow;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FlowDefinitionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(FlowDefinitionRegistry.class);
    private static Map<String, FlowDefinition> ID_DEF_MAP = new HashMap<String, FlowDefinition>();

    public void registry(FlowDefinition flowDefinition) {
        String flowId = flowDefinition.getFlowId();
        String url = flowDefinition.getUrl();
        if (StringUtils.isEmpty((Object)flowId)) {
            logger.error("flow id is empty");
            throw Error.FLOW_ID_IS_EMPTY.expcetion();
        }
        if (ID_DEF_MAP.containsKey(flowId)) {
            logger.error("Duplicate flow id! flowId={}", (Object)flowId);
            throw Error.FLOW_ID_IS_EXIST.expcetion();
        }
        ID_DEF_MAP.put(flowId, flowDefinition);
        if (!StringUtils.isEmpty((Object)url)) {
            if (!StringUtils.isEmpty((Object)FlowUtil.getFlowIdByUrl((String)url))) {
                logger.error("Duplicate url! url={}, clash flow: 1.flowId={} 2.flowId={}", new Object[]{url, FlowUtil.getFlowIdByUrl((String)url), flowId});
                throw Error.FLOW_URL_IS_EXIST.expcetion();
            }
            FlowUtil.putURLFlowId((String)url, (String)flowId);
        }
    }

    public static String getRegistryUrl(String url) {
        if (!StringUtils.isEmpty((Object)url)) {
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
        }
        return url;
    }

    public void unRegistry(StandardFlow flowDefinition) {
        String flowId = flowDefinition.getFlowId();
        String url = flowDefinition.getUrl();
        if (ID_DEF_MAP.containsKey(flowId)) {
            ID_DEF_MAP.remove(flowId);
            FlowUtil.removeURLFlowId((String)url);
        }
    }

    public FlowDefinition getFlow(String flowId) {
        return ID_DEF_MAP.get(flowId);
    }

    public Map<String, FlowDefinition> getAllFlow() {
        return ID_DEF_MAP;
    }

    public List<String> getAllFlowIds() {
        ArrayList<String> flowIds = new ArrayList<String>();
        FlowUtil.getUrlFlowidMap().forEach((k, v) -> flowIds.add((String)v));
        return flowIds;
    }

    public Set<String> getUrls(String httpMethod) {
        HashSet<String> urls = new HashSet<String>();
        ID_DEF_MAP.forEach((k, v) -> {
            String url = v.getUrl();
            String requestType = v.getRequestType();
            if (!StringUtils.isEmpty((Object)url) && v.isPublish() && httpMethod.equalsIgnoreCase(requestType)) {
                urls.add(url);
            }
        });
        return urls;
    }
}

