/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.context;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.enums.PointCode;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.ObjectUtils;

public class StandardContext
implements Context,
Serializable {
    private static final long serialVersionUID = 501L;
    private String name;
    private Map<String, Object> properties;
    private Map<String, Object> paramMap;
    private Context parent;
    private List<Context> childs;
    private Exception exception;

    public StandardContext(String name) {
        this.name = name;
        this.childs = new ArrayList<Context>();
        this.paramMap = new ConcurrentHashMap<String, Object>();
        this.properties = new ConcurrentHashMap<String, Object>();
        ActionRunTimeHolder.removePoint();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Context getParent() {
        return this.parent;
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void chainTo(Context context) {
        this.unChain();
        this.parent = context;
        context.addChild((Context)this);
        this.putProperty("_request", context.getProperties().get("_request"));
        this.putProperty("_response", context.getProperties().get("_response"));
    }

    public void unChain() {
        if (this.parent == null) {
            return;
        }
        this.parent.removeChild((Context)this);
        this.parent = null;
    }

    public void addChild(Context childContext) {
        if (this.childs == null) {
            this.childs = new ArrayList<Context>();
        }
        if (this.childs.contains(childContext)) {
            return;
        }
        this.childs.add(childContext);
    }

    public void removeChild(Context childContext) {
        childContext.setParent(null);
        this.childs.remove(childContext);
    }

    public List<Context> getChilds() {
        return this.childs;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public Object getParam(String variableName) {
        Object isSharedContext = null;
        if (!ObjectUtils.isEmpty((Object)ContextHolder.getContext())) {
            isSharedContext = ContextHolder.getContext().getProperties().get("isSharedContext");
        }
        if (!ObjectUtils.isEmpty(isSharedContext)) {
            if (((Boolean)isSharedContext).booleanValue()) {
                if (this.paramMap.containsKey(variableName)) {
                    return this.paramMap.get(variableName);
                }
                if (this.parent != null) {
                    return this.getParent().getParam(variableName);
                }
            } else if (this.paramMap.containsKey(variableName)) {
                return this.paramMap.get(variableName);
            }
        } else {
            if (this.paramMap.containsKey(variableName)) {
                return this.paramMap.get(variableName);
            }
            if (this.parent != null) {
                return this.getParent().getParam(variableName);
            }
        }
        return null;
    }

    public void putParam(String variableName, Object value) {
        this.paramMap.put(variableName, value);
    }

    public Object removeParam(String variableName) {
        return this.paramMap.remove(variableName);
    }

    public boolean containsKey(String variableName) {
        if (this.paramMap.containsKey(variableName)) {
            return true;
        }
        if (this.parent != null) {
            return this.getParent().containsKey(variableName);
        }
        return false;
    }

    public boolean containsPropertyKey(String propertyKey) {
        return this.properties.containsKey(propertyKey);
    }

    public Object getProperty(String propertyName) {
        if (this.properties.containsKey(propertyName)) {
            return this.properties.get(propertyName);
        }
        if (this.parent != null) {
            return this.getParent().getProperty(propertyName);
        }
        return null;
    }

    public void putProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public Object removeProperty(String propertyName) {
        return this.properties.remove(propertyName);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int getPoint() {
        return ActionRunTimeHolder.getPoint();
    }

    public void setPoint(int point) {
        ActionRunTimeHolder.setPoint(point);
    }

    public boolean hasException() {
        return Objects.nonNull(this.getException());
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.setPoint(PointCode.FAILURE.getCode());
    }

    public void cleanException() {
        this.exception = null;
        this.setPoint(PointCode.SUCCESS.getCode());
    }
}

