/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.transition;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.component.transition.Analyze;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionAnalyze
implements Analyze {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionAnalyze.class);

    @Override
    public boolean match(String condition, Context context, Throwable able) {
        if (able == null) {
            return false;
        }
        if (condition == null) {
            logger.warn("The exception class is not configured, and the verification result is false. Please check the configuration.");
            return false;
        }
        try {
            Class<?> currentExceptionClass = able.getClass();
            Class configExceptionClass = ClassUtil.strToClass((String)condition);
            if (able instanceof InvocationTargetException) {
                currentExceptionClass = ((InvocationTargetException)able).getTargetException().getClass();
            }
            logger.info("Exception matching: current[{}], config[{}]", currentExceptionClass, (Object)configExceptionClass);
            if (configExceptionClass.isAssignableFrom(currentExceptionClass)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("[{}] condition analysis exception", (Object)condition, (Object)e);
            throw Error.TRANSITION_EXCP_EXCEPTION.expcetion();
        }
        return false;
    }
}

