/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.flow;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.AssignType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.OpathUtil;
import cn.com.yusys.yusp.commons.fee.core.component.flow.FlowHelper;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class StandardFlow
implements Flow {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlow.class);
    private String serviceCombType = "";
    private String cancelMethod;
    private List<Action> actions = new ArrayList<Action>();
    private String flowId;
    private List<Param> input;
    private Param output;
    private String requestType;
    private boolean publish;
    private String url;
    private Map<String, Action> actionMap = new HashMap<String, Action>();
    private List<Param> global = new ArrayList<Param>();
    private String severalPreHandleClassName;
    private String severalPostHandleClassName;

    private Object getOutputValue(Context context) throws Exception {
        if (this.getOutput() != null && !StringUtils.isEmpty((Object)this.getOutput().getValue())) {
            Object param = null;
            Param output = this.getOutput();
            param = AssignType.EXPRESSION.getValue().equals(output.getAssignType()) ? OpathUtil.getObjectBySpel((String)this.getOutput().getValue(), (Context)context) : OpathUtil.getObject((Context)context, (String)this.getOutput().getValue());
            if (!StringUtils.isEmpty((Object)param)) {
                return param;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Context context) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            this.init(context);
            Action startAction = FlowHelper.getAction(ActionNodeType.START, this.actions);
            if (startAction == null) {
                throw Error.NO_START_ACTION.expcetion();
            }
            ProcessFactory.getProcess(startAction).process(startAction, context);
            Object object = this.getOutputValue(context);
            return object;
        }
        finally {
            long endTime = System.currentTimeMillis();
            logger.info("               Process time: process [{}] spent {} ms", (Object)this.flowId, (Object)(endTime - startTime));
            ((List)context.getProperty("logs")).add("               Process time: process [" + this.flowId + "] spent " + (endTime - startTime) + " ms");
            context.unChain();
        }
    }

    protected void init(Context context) throws Exception {
        if (this.global != null) {
            for (Param param : this.global) {
                Object object = ClassUtil.newInstance((String)param.getClassName());
                context.putParam(param.getName(), object);
            }
        }
        context.putProperty("_flowId", (Object)this.flowId);
    }

    public Action getAction(String actionName) {
        return this.actionMap.get(actionName);
    }

    public void addAction(String actionName, Action action) {
        this.actions.add(action);
        this.actionMap.put(actionName, action);
    }

    public List<Param> getInput() {
        return this.input;
    }

    public void setInput(List<Param> input) {
        this.input = input;
    }

    public Param getOutput() {
        return this.output;
    }

    public void setOutput(Param output) {
        this.output = output;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
        if (!actions.isEmpty()) {
            actions.forEach(e -> this.actionMap.put(e.getId(), (Action)e));
        }
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public List<Param> getGlobal() {
        return this.global;
    }

    public void setGlobal(List<Param> global) {
        this.global = global;
    }

    public Map<String, Action> getActionMap() {
        return this.actionMap;
    }

    public String getServiceCombType() {
        return this.serviceCombType;
    }

    public String getSeveralPreHandleClassName() {
        return this.severalPreHandleClassName;
    }

    public String getSeveralPostHandleClassName() {
        return this.severalPostHandleClassName;
    }

    public void setSeveralPreHandleClassName(String severalPreHandleClassName) {
        this.severalPreHandleClassName = severalPreHandleClassName;
    }

    public void setSeveralPostHandleClassName(String severalPostHandleClassName) {
        this.severalPostHandleClassName = severalPostHandleClassName;
    }

    public void setServiceCombType(String serviceCombType) {
        this.serviceCombType = serviceCombType;
    }

    public String getCancelMethod() {
        return this.cancelMethod;
    }

    public void setCancelMethod(String cancelMethod) {
        this.cancelMethod = cancelMethod;
    }
}

