/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.flow;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class FlowHelper {
    public static Action getAction(ActionNodeType type, List<Action> actions) {
        List<Action> stepList;
        for (Action action : actions) {
            if (!type.getValue().equals(action.getNodeType())) continue;
            return action;
        }
        if (Objects.equals(ActionNodeType.START, type) && !CollectionUtils.isEmpty(stepList = FlowHelper.getActions(ActionNodeType.STEP, actions))) {
            Collections.sort(stepList, (left, right) -> {
                if (NumberUtils.isNumber((CharSequence)left.getId()) && NumberUtils.isNumber((CharSequence)right.getId())) {
                    return NumberUtils.toInteger((Object)left.getId()).compareTo(NumberUtils.toInteger((Object)right.getId()));
                }
                return 0;
            });
            return stepList.get(0);
        }
        return null;
    }

    public static List<Action> getActions(ActionNodeType type, List<Action> actions) {
        return actions.stream().filter(action -> type.getValue().equals(action.getNodeType())).collect(Collectors.toList());
    }
}

