/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.component.action.abst.BaseAction;
import cn.com.yusys.yusp.commons.fee.core.component.param.ParamConverFactory;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NewObjectAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(NewObjectAction.class);

    @Override
    public Object execute(Context context) throws Exception {
        if (this.output == null || StringUtils.isEmpty((Object)this.output.getClassName())) {
            throw Error.ACTION_LACK_ATTRIBUTE.expcetion("Missing class name for the new object");
        }
        Object newObj = ClassUtil.newBaseTypeObject((String)this.output.getClassName());
        if (newObj != null) {
            return newObj;
        }
        Class[] paramClasses = null;
        Object[] paramObjects = null;
        if (this.input != null && !this.input.isEmpty()) {
            int paramLen = this.input.size();
            paramClasses = new Class[paramLen];
            paramObjects = new Object[paramLen];
            for (int i = 0; i < paramLen; ++i) {
                Param paramTmp = (Param)this.input.get(i);
                paramClasses[i] = ClassUtil.strToClass2((String)paramTmp.getClassName(), (boolean)paramTmp.isArray());
                paramObjects[i] = ParamConverFactory.getParamConver(paramTmp).conver(paramTmp, context);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Constructor parameter order[{}], type[{}], value[{}]", new Object[]{i, paramTmp.getClassName(), paramObjects[i]});
            }
        }
        Class<?> clazz = Class.forName(this.output.getClassName());
        Constructor<?> constructor = clazz.getConstructor(paramClasses);
        return constructor.newInstance(paramObjects);
    }
}

