/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.enums.PointCode;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.component.action.abst.EndAction;
import cn.com.yusys.yusp.commons.fee.core.process.ActionRunTimeHolder;
import java.util.Collection;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ConcurrentCloseAction
extends EndAction {
    private String targetConcurrentStartId;
    private long timeout = 0L;
    private Timer timer = new Timer();
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentCloseAction.class);

    @Override
    public Object execute(Context context) {
        ConcurrentHashMap<String, Queue<Future>> map = ActionRunTimeHolder.getCurrentMap();
        if (this.getTimeout() > 0L) {
            final AtomicBoolean timeoutFlag = new AtomicBoolean(false);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    timeoutFlag.set(true);
                }
            };
            this.timer.schedule(timerTask, this.getTimeout());
            Queue<Future> queue = map.get(this.targetConcurrentStartId);
            while (!timeoutFlag.get() && !CollectionUtils.isEmpty(queue)) {
                Future future = queue.peek();
                if (!ObjectUtils.isEmpty((Object)future) && future.isDone()) {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                        context.setPoint(PointCode.FAILURE.getCode());
                        throw Error.ACTION_CONCURRENT_CLOSE_FAILED.expcetion(e.getMessage());
                    }
                    finally {
                        queue.remove(future);
                    }
                }
                if (timeoutFlag.get() || CollectionUtils.isEmpty(queue)) continue;
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(200L));
            }
            if (timeoutFlag.get()) {
                if (!CollectionUtils.isEmpty(queue)) {
                    // empty if block
                }
                this.timer.purge();
                context.setPoint(PointCode.FAILURE.getCode());
                throw Error.ACTION_CONCURRENT_CLOSE_TIMEOUT.expcetion(" [" + this.getId() + "]." + this.getDescription() + " execute timeout: " + this.getTimeout() / 1000L + "s");
            }
            timerTask.cancel();
            this.timer.purge();
            context.setPoint(PointCode.SUCCESS.getCode());
        } else {
            while (!CollectionUtils.isEmpty((Collection)map.getOrDefault(this.targetConcurrentStartId, null))) {
                try {
                    Future future = map.get(this.targetConcurrentStartId).poll();
                    if (ObjectUtils.isEmpty((Object)future)) continue;
                    future.get();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    context.setPoint(PointCode.FAILURE.getCode());
                    throw Error.ACTION_CONCURRENT_CLOSE_FAILED.expcetion(e.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCloseable() {
        if (ActionRunTimeHolder.getConcurrentBeginId() != null) {
            ActionRunTimeHolder.removeConcurrentBeginId();
            return false;
        }
        return true;
    }

    public String getTargetConcurrentStartId() {
        return this.targetConcurrentStartId;
    }

    public void setTargetConcurrentStartId(String targetConcurrentStartId) {
        this.targetConcurrentStartId = targetConcurrentStartId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout > 0L ? timeout * 1000L : 0L;
    }
}

