/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component.action;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.component.action.IFlowAction;
import cn.com.yusys.yusp.commons.fee.core.component.action.abst.BaseAction;
import cn.com.yusys.yusp.commons.fee.core.component.param.ParamConverFactory;
import cn.com.yusys.yusp.commons.fee.core.context.StandardContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonFlowAction
extends BaseAction
implements IFlowAction {
    private static final Logger logger = LoggerFactory.getLogger(CommonFlowAction.class);
    private ThreadLocal<String> mainFlowId = ThreadLocal.withInitial(String::new);
    private static final String isSharedContext = "isSharedContext";
    @Autowired
    private ComponentFactory factory;
    private String flowId;
    private boolean sharedContext;

    public boolean isSharedContext() {
        return this.sharedContext;
    }

    public void setSharedContext(boolean sharedContext) {
        this.sharedContext = sharedContext;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Context context) throws Exception {
        MdcParamUtil.initParam((String)"_subFlowId", (String)this.flowId);
        try {
            Context subFlowContext = context;
            if (!this.sharedContext) {
                subFlowContext = new StandardContext(this.flowId);
                subFlowContext.chainTo(context);
                ContextHolder.getContext().getProperties().put(isSharedContext, this.sharedContext);
            } else {
                this.mainFlowId.set((String)context.getProperty("_flowId"));
            }
            this.initContext(subFlowContext);
            Flow flow = this.factory.getFlow(this.flowId);
            if (flow == null) {
                logger.error("Subflow[{}] not found", (Object)this.flowId);
                throw Error.SUBFLOW_NOT_FOUND.expcetion();
            }
            Object object = flow.execute(subFlowContext);
            return object;
        }
        finally {
            if (!this.sharedContext) {
                ContextHolder.getContext().getProperties().remove(isSharedContext);
            } else {
                context.putProperty("_flowId", (Object)this.mainFlowId.get());
            }
            MdcParamUtil.cleanParam((String)"_subFlowId");
        }
    }

    private void initContext(Context context) throws Exception {
        List<Param> input = this.getInput();
        if (input != null && !input.isEmpty()) {
            for (Param paramTmp : input) {
                Object object = null;
                object = this.sharedContext ? ParamConverFactory.getParamConver(paramTmp).conver(paramTmp, context) : ParamConverFactory.getParamConver(paramTmp).conver(paramTmp, context.getParent());
                context.putParam(paramTmp.getName(), object);
            }
        }
        if (this.sharedContext) {
            context.putProperty("_mainSubFlowActionId", (Object)this);
        }
    }
}

