/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.component;

import cn.com.yusys.yusp.commons.fee.common.component.Action;
import cn.com.yusys.yusp.commons.fee.common.component.DefCompConverter;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.core.component.flow.StandardFlow;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.converter.ConverterFactory;
import cn.com.yusys.yusp.commons.fee.core.init.converter.FlowConverter;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ComponentFactory
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ComponentFactory.class);
    private ApplicationContext applicationContext;
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;

    public void loadAllFlows() {
        List<String> flows = this.flowDefinitionRegistry.getAllFlowIds();
        flows.forEach(e -> {
            this.getFlow((String)e);
            logger.info("Preload succeeded, flowId={}", e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flow getFlow(String flowId) {
        String beanId = "flowBeanId_" + flowId;
        if (this.applicationContext.containsBean(beanId)) {
            return (StandardFlow)this.applicationContext.getBean(beanId);
        }
        ComponentFactory componentFactory = this;
        synchronized (componentFactory) {
            DefCompConverter flowConverter;
            FlowDefinition flowDefinition = this.flowDefinitionRegistry.getFlow(flowId);
            if (flowDefinition != null && (flowConverter = ConverterFactory.getConverter(FlowConverter.class)) != null) {
                return (Flow)flowConverter.convert((Object)flowDefinition, flowId);
            }
        }
        return null;
    }

    public Action getAction(Flow flow, String actionId) {
        return this.getAction(flow.getFlowId(), actionId);
    }

    public Action getAction(String flowId, String actionId) {
        List<Action> actions = this.getActions(flowId);
        for (Action e : actions) {
            if (!actionId.equals(e.getId())) continue;
            return e;
        }
        return null;
    }

    public List<Action> getActions(String flowId) {
        return this.getFlow(flowId).getActions();
    }

    public List<Action> getActions(Flow flow) {
        return flow.getActions();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

