/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.core.api.rest;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.ContextUtil;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.LocalMark;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.api.FeeResultDto;
import cn.com.yusys.yusp.commons.fee.core.api.IdempotentProcessor;
import cn.com.yusys.yusp.commons.fee.core.api.ResultDtoConvert;
import cn.com.yusys.yusp.commons.fee.core.api.rest.ParamConvert;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.context.StandardContext;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ParamDefinition;
import cn.com.yusys.yusp.commons.fee.core.intercepter.AllFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeeInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeePostFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeePreFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessCoord;
import cn.com.yusys.yusp.commons.fee.core.util.BeanUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
public class FeeAccessController {
    private static final Logger logger = LoggerFactory.getLogger(FeeAccessController.class);
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;
    @Autowired
    private ComponentFactory componentFactory;
    @Autowired(required=false)
    private AllFlowInterceptor allFlowInterceptor;
    @Autowired
    private ProcessCoord processCoord;
    @Autowired
    private IdempotentProcessor idempotentProcessor;
    @Autowired(required=false)
    private ResultDtoConvert resultDtoConvert;

    public Object postAccess(@RequestBody(required=false) ObjectNode objectNode, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.commonAccess(objectNode, request, response, HttpMethod.POST);
    }

    public Object getAccess(@RequestParam(required=false) Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.commonAccess(params, request, response, HttpMethod.GET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object commonAccess(Object params, HttpServletRequest request, HttpServletResponse response, HttpMethod httpMethod) throws Throwable {
        String url = request.getRequestURI();
        String flowId = FlowUtil.getFlowIdByUrl((String)url);
        FeeResultDto<Object> result = null;
        if (StringUtils.isEmpty((Object)flowId)) {
            logger.warn("Interface not found: url = {}", (Object)url);
            return new FeeResultDto(Error.NOT_FOUND);
        }
        FlowDefinition flowDefinition = this.flowDefinitionRegistry.getFlow(flowId);
        this.initContext(flowId);
        MdcParamUtil.initParam((String)"_flowId", (String)flowId);
        FeeInterceptor feeInterceptor = (FeeInterceptor)SpringContextHolder.getBeanIfExist((String)flowDefinition.getIntercepterName());
        LinkedBlockingQueue queue = null;
        queue = this.getInterceptorClassNameQueue(queue, flowDefinition.getSeveralPreHandleClassName());
        this.handleRequest(feeInterceptor, params, httpMethod, queue);
        queue = this.getInterceptorClassNameQueue(queue, flowDefinition.getSeveralPostHandleClassName());
        logger.info("Process input: url={},flowId={},request={}", new Object[]{url, flowId, params});
        List<Definition> input = flowDefinition.getInput();
        ParamConvert.convert(params, input, httpMethod);
        String iptKey = null;
        Object data = null;
        FeeResultDto<Object> dto = null;
        try {
            this.validate(flowDefinition);
            iptKey = this.idempotentProcessor.getIptKey(flowDefinition);
            result = this.idempotentProcessor.startIdempotent(flowDefinition, iptKey);
            if (result == null) {
                Flow flow = this.componentFactory.getFlow(flowId);
                data = this.processCoord.processExecute(flow);
                result = new FeeResultDto<Object>(data);
                this.idempotentProcessor.processIdempotent(flowDefinition, result, iptKey);
            }
            this.idempotentProcessor.clearIdempotent(flowDefinition, result, iptKey);
        }
        catch (Exception e) {
            FeeResultDto<Object> feeResultDto;
            block22: {
                ArrayList logs = (ArrayList)ContextUtil.getProperty((String)"logs");
                if (!CollectionUtils.isEmpty((Collection)logs)) {
                    logs.forEach(log -> logger.error(log));
                }
                if (LocalMark.isTccServiceCombType().booleanValue()) {
                    throw e;
                }
                if (e instanceof FeeException) {
                    FeeException fe = (FeeException)e;
                    logger.error("{}", (Object)fe.getTraceInfo());
                    if (!ObjectUtils.isEmpty((Object)this.resultDtoConvert)) {
                        dto = this.resultDtoConvert.debugConvert((Exception)fe);
                    }
                    if (ObjectUtils.isEmpty((Object)dto)) {
                        result = new FeeResultDto(fe.getCode(), fe.getMessage());
                    }
                } else {
                    if (!ObjectUtils.isEmpty((Object)this.resultDtoConvert)) {
                        dto = this.resultDtoConvert.debugConvert(e);
                    }
                    if (ObjectUtils.isEmpty(dto)) {
                        result = new FeeResultDto("000001", e.getMessage());
                    }
                }
                if (ObjectUtils.isEmpty((Object)dto)) break block22;
                this.handleResponse(feeInterceptor, dto, queue);
                feeResultDto = dto;
                return feeResultDto;
            }
            this.handleResponse(feeInterceptor, result, queue);
            feeResultDto = result;
            return feeResultDto;
        }
        finally {
            this.idempotentProcessor.clearIdempotent(flowDefinition, result, iptKey);
            MdcParamUtil.cleanParam((String)"_flowId");
        }
        MdcParamUtil.cleanParam((String)"_flowId");
        try {
            FeeResultDto<Object> feeResultDto;
            if (!ObjectUtils.isEmpty((Object)this.resultDtoConvert)) {
                dto = this.resultDtoConvert.convertDTO(data);
            }
            if (!ObjectUtils.isEmpty((Object)dto)) {
                this.handleResponse(feeInterceptor, dto, queue);
                logger.info("Process output: url={}, flowId={}, response={}", new Object[]{url, flowId, dto});
                feeResultDto = dto;
                return feeResultDto;
            }
            this.handleResponse(feeInterceptor, result, queue);
            logger.info("Process output: url={}, flowId={}, response={}", new Object[]{url, flowId, data});
            feeResultDto = result;
            return feeResultDto;
        }
        finally {
            ContextHolder.removeContext();
        }
    }

    private void validate(FlowDefinition flowDefinition) throws FeeException, ClassNotFoundException {
        Context rootContext = ContextHolder.getContext();
        List<Definition> input = flowDefinition.getInput();
        for (int i = 0; i < input.size(); ++i) {
            Object param;
            ParamDefinition paramDefinition = (ParamDefinition)input.get(i);
            String className = paramDefinition.getClassName();
            if (!BeanUtil.isJavaClass(Class.forName(className)) && !ObjectUtils.isEmpty((Object)(param = rootContext.getParam(paramDefinition.getName())))) continue;
        }
    }

    private void initContext(String flowId) {
        StandardContext rootContext = new StandardContext("rootContext");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        rootContext.putProperty("_flowUrl", request.getRequestURI());
        rootContext.putProperty("_request", request);
        rootContext.putProperty("_response", response);
        rootContext.putProperty("flowId", flowId);
        rootContext.putProperty("logs", new ArrayList());
        ContextHolder.setContext((Context)rootContext);
    }

    private LinkedBlockingQueue getInterceptorClassNameQueue(LinkedBlockingQueue queue, String severalPostHandleClassName) {
        if (!StringUtils.isEmpty((Object)severalPostHandleClassName)) {
            String[] postHandleClassNames = severalPostHandleClassName.split(";");
            queue = new LinkedBlockingQueue<String>();
            for (String className : postHandleClassNames) {
                queue.add(className);
            }
        }
        return queue;
    }

    private void handleRequest(FeeInterceptor feeInterceptor, Object params, HttpMethod httpMethod, Queue<String> queue) throws Exception {
        if (this.allFlowInterceptor != null) {
            this.handleRequest2(this.allFlowInterceptor, params, httpMethod);
        }
        if (!CollectionUtils.isEmpty(queue)) {
            while (queue.peek() != null) {
                FeePreFlowInterceptor preFlowInterceptor = (FeePreFlowInterceptor)ClassUtil.newInstance((String)queue.poll());
                switch (httpMethod) {
                    case GET: {
                        preFlowInterceptor.preHandle((Map)params);
                        break;
                    }
                    case POST: {
                        preFlowInterceptor.preHandle((ObjectNode)params);
                    }
                }
            }
        }
        if (feeInterceptor != null) {
            this.handleRequest2(feeInterceptor, params, httpMethod);
        }
    }

    private void handleRequest2(FeeInterceptor feeInterceptor, Object params, HttpMethod httpMethod) {
        if (feeInterceptor != null) {
            switch (httpMethod) {
                case GET: {
                    feeInterceptor.getRequestHandle((Map)params);
                    break;
                }
                case POST: {
                    feeInterceptor.postRequestHandle((ObjectNode)params);
                }
            }
        }
    }

    private void handleResponse(FeeInterceptor feeInterceptor, Object result, Queue<String> queue) throws Exception {
        if (!ObjectUtils.isEmpty((Object)result)) {
            if (!CollectionUtils.isEmpty(queue)) {
                while (queue.peek() != null) {
                    FeePostFlowInterceptor preFlowInterceptor = (FeePostFlowInterceptor)ClassUtil.newInstance((String)queue.poll());
                    preFlowInterceptor.postHandle(result);
                }
            }
            if (feeInterceptor != null) {
                feeInterceptor.responseHandle(result);
            }
            if (this.allFlowInterceptor != null) {
                this.allFlowInterceptor.responseHandle(result);
            }
        }
    }
}

