/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.util;

import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class OpathUtil {
    private static final Logger logger = LoggerFactory.getLogger(OpathUtil.class);

    public static Object getObjectBySpel(String value, Context context) {
        Map<String, Object> map;
        Object param = null;
        SpelExpressionParser parser = new SpelExpressionParser();
        if (value.startsWith("@")) {
            map = context.getProperties();
            value = value.substring(1);
        } else {
            map = context.getParamMap();
        }
        if (!value.startsWith("[")) {
            value = "[" + value + "]";
        }
        param = parser.parseExpression(value).getValue(map);
        return param;
    }

    public static Object getObject(Context context, String opath) {
        Queue<String> queue = OpathUtil.strToQueue(opath);
        String objectVariableName = queue.poll();
        Object parent = context.getParam(objectVariableName);
        return OpathUtil.getInstance(parent, queue);
    }

    public static Queue<String> strToQueue(String opath) {
        return Arrays.stream(opath.split("\\.")).filter(s -> s.length() > 0).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
    }

    public static boolean isOpath(String opath) {
        return opath.contains(".");
    }

    public static boolean isSql(String sql) {
        return sql.trim().toUpperCase().startsWith("SELECT ") || sql.trim().toUpperCase().startsWith("UPDATE ") || sql.trim().toUpperCase().startsWith("DELETE ") || sql.trim().toUpperCase().startsWith("INSERT ");
    }

    public static Object updateObject(String opath, Context context, Object rightValue, String className) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("opth[{}], instantiation start", (Object)opath);
        }
        long startTime = System.currentTimeMillis();
        Object parent = null;
        Queue<String> queue = OpathUtil.strToQueue(opath);
        String objectVariableName = queue.poll();
        if (queue.size() == 1 && OpathUtil.isAssignAbleFromMap(context.getParam(objectVariableName).getClass())) {
            ((Map)context.getParam(objectVariableName)).put(queue.peek(), rightValue);
            return rightValue;
        }
        parent = OpathUtil.fieldInstance(context.getParam(objectVariableName), queue, rightValue, className);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("opth[{}], instantiation finished, cost[{}]", (Object)opath, (Object)(endTime - startTime));
        }
        if (parent != null) {
            context.putParam(objectVariableName, parent);
        }
        return parent;
    }

    public static Object updateObjectBySql(String opath, Context context, Object rightValue, String className) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("opth[{}], instantiation start", (Object)opath);
        }
        HashMap hashMap = new HashMap();
        if (rightValue instanceof ArrayList) {
            if (((ArrayList)rightValue).size() > 1) {
                throw Error.INNER_ERROR.expcetion();
            }
            hashMap = (HashMap)((ArrayList)rightValue).get(0);
        }
        long startTime = System.currentTimeMillis();
        Object parent = null;
        Queue<String> queue = OpathUtil.strToQueue(opath);
        String objectVariableName = queue.poll();
        String s = (String)Arrays.stream(opath.split("\\.")).collect(Collectors.toList()).get(opath.split("\\.").length - 1);
        parent = OpathUtil.fieldInstance(context.getParam(objectVariableName), queue, hashMap.get(s), className);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("opth[{}], instantiation finished, cost[{}]", (Object)opath, (Object)(endTime - startTime));
        }
        context.putParam(objectVariableName, parent);
        return parent;
    }

    public static final Object fieldInstance(Object parent, Queue<String> queue, Object rightValue, String className) throws Exception {
        if (null == queue || queue.isEmpty()) {
            logger.warn("opath is empty");
            return null;
        }
        if (null == rightValue) {
            logger.warn("The right variable is empty");
            return null;
        }
        if (null == parent) {
            logger.warn("Object is empty, unable to load properties");
            return null;
        }
        Object newObject = null;
        if (queue.size() == 2 && OpathUtil.isAssignAbleFromMap(ClassUtil.getField(parent, queue.peek()).getType())) {
            Field field = ClassUtil.getField(parent, queue.poll());
            try {
                Method method = ClassUtil.getGetter(parent, field);
                Map<String, Object> map = (HashMap<String, Object>)method.invoke(parent, null);
                if (null == map) {
                    map = field.getType().isInterface() ? new HashMap<String, Object>() : (Map)field.getType().newInstance();
                    map.put(queue.poll(), rightValue);
                    Method setter = ClassUtil.getSetter(parent, field);
                    setter.invoke(parent, map);
                }
                map.put(queue.poll(), rightValue);
            }
            catch (Exception e) {
                throw Error.INNER_ERROR.expcetion();
            }
        } else {
            String objectVariable = queue.poll();
            Field field = ClassUtil.getField(parent, objectVariable);
            if (null == field) {
                logger.warn("Field [{}] cannot exist", (Object)objectVariable);
                return null;
            }
            if (!queue.isEmpty()) {
                newObject = ClassUtil.getObjectFieldValue(parent, field);
                if (newObject == null) {
                    newObject = ClassUtil.newInstance(field.getType().getCanonicalName());
                    ClassUtil.setFieldValue(parent, field, newObject);
                }
                OpathUtil.fieldInstance(newObject, queue, rightValue, className);
            } else {
                ClassUtil.setFieldValue(parent, field, rightValue);
            }
        }
        return parent;
    }

    public static final Object getInstance(Object parent, Queue<String> queue) {
        if (null == queue || queue.isEmpty()) {
            return parent;
        }
        if (null == parent) {
            logger.warn("Object is empty, unable to load properties");
            return null;
        }
        if (queue.size() == 2 && OpathUtil.isAssignAbleFromMap(ClassUtil.getField(parent, queue.peek()).getType())) {
            return OpathUtil.getValueFromMap(parent, queue);
        }
        Object newObject = null;
        String objectVariable = queue.poll();
        Field field = ClassUtil.getField(parent, objectVariable);
        if (null == field) {
            logger.warn("\u5b57\u6bb5[{}]\u4e0d\u80fd\u5b58\u5728", (Object)objectVariable);
            return null;
        }
        newObject = ClassUtil.getObjectFieldValue(parent, field);
        return OpathUtil.getInstance(newObject, queue);
    }

    public static boolean isAssignAbleFromMap(Class aClass) {
        try {
            Class<?> mapClass = Class.forName("java.util.Map");
            return mapClass.isAssignableFrom(aClass);
        }
        catch (Exception e) {
            throw Error.INNER_ERROR.expcetion();
        }
    }

    public static boolean isAssignAbleFromList(Class aClass) {
        try {
            Class<?> mapClass = Class.forName("java.util.List");
            return mapClass.isAssignableFrom(aClass);
        }
        catch (Exception e) {
            throw Error.INNER_ERROR.expcetion();
        }
    }

    public static Object getValueFromMap(Object parent, Queue<String> queue) {
        Field field = ClassUtil.getField(parent, queue.poll());
        Map invoke = null;
        try {
            Method method = ClassUtil.getGetter(parent, field);
            invoke = (Map)method.invoke(parent, null);
            Object object = invoke.get(queue.poll());
            if (null == object) {
                throw Error.NOT_FOUND_VALUE.expcetion();
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw Error.INNER_ERROR.expcetion();
        }
        catch (IllegalArgumentException e) {
            throw Error.INNER_ERROR.expcetion();
        }
        catch (InvocationTargetException e) {
            throw Error.INNER_ERROR.expcetion();
        }
        catch (FeeException e) {
            throw Error.NOT_FOUND_VALUE.expcetion();
        }
    }

    public static Object getValueFromList(Object parent, Queue<String> queue) {
        Field field = ClassUtil.getField(parent, queue.poll());
        try {
            Method method = ClassUtil.getGetter(parent, field);
            List invoke = (List)method.invoke(parent, null);
            return invoke.get(Integer.valueOf(queue.poll()));
        }
        catch (Exception e) {
            throw Error.INNER_ERROR.expcetion();
        }
    }
}

